/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.IOException;
import java.util.List;

public abstract class OverthereFileDirectoryWalker {
    public static final int ROOT = 0;
    private final int depthLimit;

    protected OverthereFileDirectoryWalker() {
        this(-1);
    }

    protected OverthereFileDirectoryWalker(int n) {
        this.depthLimit = n;
    }

    protected final void walk(OverthereFile overthereFile) throws RuntimeIOException {
        try {
            if (overthereFile == null) {
                throw new NullPointerException("Start Directory is null");
            }
            this.handleStart(overthereFile);
            this.walk(overthereFile, 0);
            this.handleEnd();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private void walk(OverthereFile overthereFile, int n) throws IOException {
        if (this.handleDirectory(overthereFile, n)) {
            this.handleDirectoryStart(overthereFile, n);
            int n2 = n + 1;
            if (this.depthLimit < 0 || n2 <= this.depthLimit) {
                List<OverthereFile> list = this.listFiles(overthereFile);
                if (list == null) {
                    this.handleRestricted(overthereFile, n2);
                } else {
                    for (OverthereFile overthereFile2 : list) {
                        if (overthereFile2.isDirectory()) {
                            this.walk(overthereFile2, n2);
                            continue;
                        }
                        this.handleFile(overthereFile2, n2);
                    }
                }
            }
            this.handleDirectoryEnd(overthereFile, n);
        }
    }

    protected List<OverthereFile> listFiles(OverthereFile overthereFile) {
        return overthereFile.listFiles();
    }

    protected void handleStart(OverthereFile overthereFile) throws IOException {
    }

    protected boolean handleDirectory(OverthereFile overthereFile, int n) throws IOException {
        return true;
    }

    protected void handleDirectoryStart(OverthereFile overthereFile, int n) throws IOException {
    }

    protected void handleFile(OverthereFile overthereFile, int n) throws IOException {
    }

    protected void handleRestricted(OverthereFile overthereFile, int n) throws IOException {
    }

    protected void handleDirectoryEnd(OverthereFile overthereFile, int n) throws IOException {
    }

    protected void handleEnd() throws IOException {
    }
}

