/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public abstract class PDXObjectImage
extends PDXObject {
    private static final Log log = LogFactory.getLog(PDXObjectImage.class);
    public static final String SUB_TYPE = "Image";
    private String suffix;
    private PDGraphicsState graphicsState;

    public PDXObjectImage(PDStream imageStream, String fileSuffix) {
        super(imageStream);
        this.suffix = fileSuffix;
    }

    public PDXObjectImage(PDDocument doc, String fileSuffix) {
        super(doc);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
        this.suffix = fileSuffix;
    }

    public abstract BufferedImage getRGBImage() throws IOException;

    public PDXObjectImage getSMaskImage() throws IOException {
        COSStream cosStream = this.getPDStream().getStream();
        COSBase smask = cosStream.getDictionaryObject(COSName.SMASK);
        if (smask == null) {
            return null;
        }
        return (PDXObjectImage)PDXObject.createXObject(smask);
    }

    public abstract void write2OutputStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2file(String filename) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename + "." + this.suffix);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2file(File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int getHeight() {
        return this.getCOSStream().getInt(COSName.HEIGHT, -1);
    }

    public void setHeight(int height) {
        this.getCOSStream().setInt(COSName.HEIGHT, height);
    }

    public int getWidth() {
        return this.getCOSStream().getInt(COSName.WIDTH, -1);
    }

    public void setWidth(int width) {
        this.getCOSStream().setInt(COSName.WIDTH, width);
    }

    public int getBitsPerComponent() {
        return this.getCOSStream().getInt(new String[]{"BPC", "BitsPerComponent"}, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.getCOSStream().setInt("BitsPerComponent", bpc);
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.getCOSStream().getDictionaryObject(new String[]{"CS", "ColorSpace"});
        PDColorSpace retval = null;
        if (cs != null) {
            retval = PDColorSpaceFactory.createColorSpace(cs);
            if (retval == null) {
                log.info((Object)"About to return NULL from createColorSpace branch");
            }
        } else {
            COSBase filter = this.getCOSStream().getDictionaryObject("Filter");
            if (COSName.CCITTFAX_DECODE.equals(filter) || COSName.CCITTFAX_DECODE_ABBREVIATION.equals(filter)) {
                retval = new PDDeviceGray();
                if (retval == null) {
                    log.info((Object)"About to return NULL from CCITT branch");
                }
            } else if (COSName.JBIG2_DECODE.equals(filter)) {
                retval = new PDDeviceGray();
                if (retval == null) {
                    log.info((Object)"About to return NULL from JBIG2 branch");
                }
            } else if (this.getImageMask()) {
                retval = this.graphicsState.getNonStrokingColor().getColorSpace();
                log.info((Object)("Stencil Mask branch returning " + retval.toString()));
            } else {
                log.info((Object)("About to return NULL from unhandled branch. filter = " + filter));
            }
        }
        return retval;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.getCOSStream().setItem(COSName.COLORSPACE, base);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean getImageMask() {
        return this.getCOSStream().getBoolean(COSName.IMAGE_MASK, false);
    }

    public void setGraphicsState(PDGraphicsState newGS) {
        this.graphicsState = newGS;
    }

    public COSArray getDecode() {
        COSBase decode = this.getCOSStream().getDictionaryObject(COSName.DECODE);
        if (decode != null && decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    public COSArray getMask() {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask != null) {
            return (COSArray)mask;
        }
        return null;
    }
}

