/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.deployment.InitialDeploymentTask;
import com.xebialabs.deployit.task.deployment.UndeploymentTask;
import com.xebialabs.deployit.task.deployment.UpgradeDeploymentTask;
import com.xebialabs.deployit.task.step.RepositoryUpdateStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentService {
    private RepositoryService repositoryService;
    private Planner planner;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(RepositoryService repositoryService, Planner planner) {
        this.repositoryService = repositoryService;
        this.planner = planner;
    }

    public Task prepareInitialDeployment(DeployedApplication deployedApplication, Collection<Deployed> collection, WorkDir workDir) {
        DeltaSpecificationBuilder deltaSpecificationBuilder = DeltaSpecificationBuilder.newSpecification().initial(deployedApplication);
        DeploymentOperationCalculator.calculate(deltaSpecificationBuilder, Sets.newHashSet(), Sets.newHashSet(collection));
        DeltaSpecification deltaSpecification = deltaSpecificationBuilder.build();
        Plan plan = this.planner.plan(deltaSpecification);
        List<DeploymentStep> list = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new InitialDeploymentTask(deltaSpecification, list, this.repositoryService, workDir);
    }

    public Task prepareUpgradeDeployment(DeployedApplication deployedApplication, DeployedApplication deployedApplication2, Collection<Deployed> collection, WorkDir workDir, WorkDir workDir2) {
        DeltaSpecificationBuilder deltaSpecificationBuilder = DeltaSpecificationBuilder.newSpecification().upgrade(deployedApplication);
        HashSet hashSet = Sets.newHashSet(collection);
        logger.trace("Incoming Deployeds {}", (Object)hashSet);
        logger.trace("Existing Deployeds {}", (Object)deployedApplication2.getDeployeds());
        DeploymentOperationCalculator.calculate(deltaSpecificationBuilder, deployedApplication2.getDeployeds(), hashSet);
        DeltaSpecification deltaSpecification = deltaSpecificationBuilder.build();
        Plan plan = this.planner.plan(deltaSpecification);
        List<DeploymentStep> list = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new UpgradeDeploymentTask(deltaSpecification, deployedApplication2, list, this.repositoryService, workDir, workDir2);
    }

    public Task prepareUndeployment(DeployedApplication deployedApplication, WorkDir workDir) {
        DeltaSpecificationBuilder deltaSpecificationBuilder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(deltaSpecificationBuilder, deployedApplication.getDeployeds(), Sets.newHashSet());
        DeltaSpecification deltaSpecification = deltaSpecificationBuilder.build();
        Plan plan = this.planner.plan(deltaSpecification);
        List<DeploymentStep> list = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new UndeploymentTask(deltaSpecification, deployedApplication, list, this.repositoryService, workDir);
    }

    private List<DeploymentStep> getStepsFromPlanOrDefaultUpdateStep(Plan plan) {
        List list = plan.getSteps();
        if (list.isEmpty()) {
            list = Lists.newArrayList((Object[])new DeploymentStep[]{new RepositoryUpdateStep()});
        }
        return list;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class DeploymentException
    extends DeployitException {
        public DeploymentException(String string) {
            super(string);
        }
    }
}

