/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TypeCalculator {
    public Type findMostSpecificDeployedTypeForDeployableAndContainerTypes(Type type, Type type2) {
        List<Type> list = this.findDeployedTypesForDeployableAndContainerTypes(type, type2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        List<Type> list2 = this.filterMostSpecific(list);
        if (list2.size() == 1) {
            return list2.get(0);
        }
        throw new IllegalArgumentException(String.format("Found %s for %s and %s, expected only 1", list2, type, type2));
    }

    List<Type> filterMostSpecific(List<Type> list) {
        ArrayList arrayList = Lists.newArrayList(list);
        for (Type type : list) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Type type2 = (Type)iterator.next();
                Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)type2);
                boolean bl = descriptor2.getDeployableType().equals((Object)descriptor.getDeployableType());
                boolean bl2 = descriptor2.getContainerType().equals((Object)descriptor.getContainerType());
                boolean bl3 = descriptor2.getContainerType().isSuperTypeOf(descriptor.getContainerType());
                boolean bl4 = descriptor2.getDeployableType().isSuperTypeOf(descriptor.getDeployableType());
                boolean bl5 = type2.isSuperTypeOf(type);
                if (!(bl3 && bl || bl4 && bl2 || bl4 && bl3) && !bl5) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    public List<Type> findDeployedTypesForDeployableAndContainerTypes(Type type, Type type2) {
        Collection collection = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Deployed.class));
        final Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        final Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)type2);
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)collection, (Predicate)new Predicate<Type>(){

            public boolean apply(Type type) {
                Descriptor descriptor3 = DescriptorRegistry.getDescriptor((Type)type);
                return !descriptor3.isVirtual() && descriptor.isAssignableTo(descriptor3.getDeployableType()) && descriptor2.isAssignableTo(descriptor3.getContainerType());
            }
        }));
    }
}

