/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.jcrarchive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import com.xebialabs.deployit.task.jcrarchive.JcrArchivedTaskSearchQueryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTaskArchive
implements TaskArchive {
    static final String STATE = "state";
    static final String START_DATE = "startDate";
    static final String COMPLETION_DATE = "completionDate";
    static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    static final String NR_OF_STEPS = "nrOfSteps";
    static final String CURRENT_STEP_NR = "currentStepNr";
    static final String OWNING_USER = "ownerUser";
    static final String FAILURE_COUNT = "failureCount";
    static final String LOG = "log";
    static final String DESCRIPTION = "description";
    static final String APPLICATION = "application";
    static final String VERSION = "version";
    static final String ENVIRONMENT = "environment";
    static final String DEPLOYMENT_TYPE = "deploymentType";
    private final JcrTemplate jcrTemplate;
    private static final Pattern qualifiedTaskIdPattern = Pattern.compile("(.*)/(.*)/(.*)/(.*)");

    @Autowired
    public JcrTaskArchive(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public void archiveTask(DeploymentTask deploymentTask) {
        this.checkAllMandatoryAttributesArePresentInDeploymentTask(deploymentTask);
        this.saveDeploymentTask(deploymentTask);
    }

    private void checkAllMandatoryAttributesArePresentInDeploymentTask(DeploymentTask deploymentTask) {
        Preconditions.checkState((!Strings.nullToEmpty((String)deploymentTask.getApplicationName()).isEmpty() ? 1 : 0) != 0, (Object)"applicationName in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)deploymentTask.getApplicationVersion()).isEmpty() ? 1 : 0) != 0, (Object)"applicationVersion in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)deploymentTask.getEnvironment()).isEmpty() ? 1 : 0) != 0, (Object)"environment in deployment task must be set");
    }

    private void saveDeploymentTask(final DeploymentTask deploymentTask) {
        this.jcrTemplate.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrTaskArchive.this.createJcrTaskNodeAndAssociatedParentNodes(deploymentTask, JcrTaskArchive.this.getTasksRootNode(session));
                JcrTaskArchive.this.mapDeploymentTaskToJcrNode(deploymentTask, node);
                session.save();
                return null;
            }
        });
    }

    private Node createJcrTaskNodeAndAssociatedParentNodes(DeploymentTask deploymentTask, Node node) throws RepositoryException {
        Node node2 = this.createNodeIfDoesNotExist(node, deploymentTask.getEnvironment());
        Node node3 = this.createNodeIfDoesNotExist(node2, deploymentTask.getApplicationName());
        Node node4 = this.createNodeIfDoesNotExist(node3, deploymentTask.getApplicationVersion());
        Node node5 = node4.addNode(deploymentTask.getId());
        node5.addMixin("deployit:task");
        return node5;
    }

    private Node createNodeIfDoesNotExist(Node node, String string) throws RepositoryException {
        if (node.hasNode(string)) {
            return node.getNode(string);
        }
        return node.addNode(string);
    }

    private void mapDeploymentTaskToJcrNode(DeploymentTask deploymentTask, Node node) throws IOException, RepositoryException {
        node.setProperty("$id", deploymentTask.getId());
        node.setProperty(STATE, deploymentTask.getState().name());
        node.setProperty(START_DATE, deploymentTask.getStartDate());
        node.setProperty(COMPLETION_DATE, deploymentTask.getCompletionDate());
        node.setProperty(CURRENT_STEP_NR, (long)deploymentTask.getCurrentStepNr());
        node.setProperty(NR_OF_STEPS, (long)deploymentTask.getNrOfSteps());
        node.setProperty(OWNING_USER, deploymentTask.getOwner());
        node.setProperty(APPLICATION, deploymentTask.getApplicationName());
        node.setProperty(VERSION, deploymentTask.getApplicationVersion());
        node.setProperty(ENVIRONMENT, deploymentTask.getEnvironment());
        node.setProperty(FAILURE_COUNT, (long)deploymentTask.getFailureCount());
        node.setProperty(DEPLOYMENT_TYPE, deploymentTask.getDeploymentType().name());
        for (int i = 1; i <= deploymentTask.getNrOfSteps(); ++i) {
            TaskStep taskStep = deploymentTask.getStep(i);
            Node node2 = node.addNode("step" + i);
            node2.setProperty(DESCRIPTION, taskStep.getDescription());
            node2.setProperty(LAST_MODIFICATION_DATE, taskStep.getLastModificationDate());
            node2.setProperty(STATE, taskStep.getState().name());
            node2.setProperty(START_DATE, taskStep.getStartDate());
            node2.setProperty(COMPLETION_DATE, taskStep.getCompletionDate());
            node2.setProperty(FAILURE_COUNT, (long)taskStep.getFailureCount());
            node2.setProperty(LOG, taskStep.getLog());
        }
    }

    @Override
    public DeploymentTaskInfo getTask(String string) {
        if (qualifiedTaskIdPattern.matcher(string).matches()) {
            return this.getTaskUsingFullyQualifiedPath(string);
        }
        return this.getTaskUsingUuid(string);
    }

    private DeploymentTaskInfo getTaskUsingFullyQualifiedPath(final String string) {
        return this.jcrTemplate.execute(new JcrCallback<DeploymentTaskInfo>(){

            @Override
            public DeploymentTaskInfo doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = JcrTaskArchive.this.getTasksRootNode(session);
                    Node node2 = node.getNode(string);
                    DeploymentTaskInfo deploymentTaskInfo = JcrTaskArchive.this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(node2);
                    if (deploymentTaskInfo == null) {
                        throw new NotFoundException("Cannot load task " + string + " because that object with that id is not a task", new Object[0]);
                    }
                    deploymentTaskInfo.setSteps(JcrTaskArchive.this.loadTaskStepInfosForJcrTaskNode(node2));
                    return deploymentTaskInfo;
                }
                catch (PathNotFoundException pathNotFoundException) {
                    throw new NotFoundException("Cannot load task " + string + ": " + pathNotFoundException.toString(), new Object[]{pathNotFoundException});
                }
            }
        });
    }

    private DeploymentTaskInfo getTaskUsingUuid(String string) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.withUniqueId(string);
        Collection<DeploymentTaskInfo> collection = this.searchTasks(archivedTaskSearchParameters);
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        if (collection.isEmpty()) {
            throw new NotFoundException("Cannot load task " + string, new Object[0]);
        }
        throw new NotFoundException("Cannot load task " + string + " because there are multiple tasks with same id. " + collection, new Object[0]);
    }

    private DeploymentTaskInfo mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(Node node) throws RepositoryException {
        if (!node.isNodeType("deployit:task")) {
            return null;
        }
        DeploymentTaskInfo deploymentTaskInfo = new DeploymentTaskInfo();
        deploymentTaskInfo.setId(this.getPropertyFromJcrNode(node, "$id"));
        deploymentTaskInfo.setEnvironment(this.getPropertyFromJcrNode(node, ENVIRONMENT));
        deploymentTaskInfo.setApplicationName(this.getPropertyFromJcrNode(node, APPLICATION));
        deploymentTaskInfo.setApplicationVersion(this.getPropertyFromJcrNode(node, VERSION));
        deploymentTaskInfo.setState(Task.State.valueOf(this.getPropertyFromJcrNode(node, STATE)));
        deploymentTaskInfo.setDeploymentType(DeploymentTask.DeploymentType.valueOf(this.getPropertyFromJcrNode(node, DEPLOYMENT_TYPE)));
        deploymentTaskInfo.setStartDate(this.getOptionalDatePropertyFromJcrNode(node, START_DATE));
        deploymentTaskInfo.setCompletionDate(this.getOptionalDatePropertyFromJcrNode(node, COMPLETION_DATE));
        deploymentTaskInfo.setOwner(this.getOptionalPropertyFromJcrNode(node, OWNING_USER));
        deploymentTaskInfo.setCurrentStepNr(this.getIntegerPropertyFromJcrNode(node, CURRENT_STEP_NR));
        deploymentTaskInfo.setFailureCount(this.getIntegerPropertyFromJcrNode(node, FAILURE_COUNT));
        return deploymentTaskInfo;
    }

    private String getPropertyFromJcrNode(Node node, String string) throws RepositoryException {
        return node.getProperty(string).getString();
    }

    private int getIntegerPropertyFromJcrNode(Node node, String string) throws RepositoryException {
        return (int)node.getProperty(string).getLong();
    }

    private Calendar getOptionalDatePropertyFromJcrNode(Node node, String string) throws RepositoryException {
        if (node.hasProperty(string)) {
            return node.getProperty(string).getDate();
        }
        return null;
    }

    private String getOptionalPropertyFromJcrNode(Node node, String string) throws RepositoryException {
        if (node.hasProperty(string)) {
            return node.getProperty(string).getString();
        }
        return null;
    }

    private List<TaskStepInfo> loadTaskStepInfosForJcrTaskNode(Node node) throws RepositoryException {
        int n = this.getIntegerPropertyFromJcrNode(node, NR_OF_STEPS);
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 1; i <= n; ++i) {
            Node node2 = node.getNode("step" + i);
            arrayList.add(this.mapJcrStepNodeToTaskStepInfo(node2));
        }
        return arrayList;
    }

    private TaskStepInfo mapJcrStepNodeToTaskStepInfo(Node node) throws RepositoryException {
        String string = this.getPropertyFromJcrNode(node, DESCRIPTION);
        TaskStepInfo.StepState stepState = TaskStepInfo.StepState.valueOf(this.getPropertyFromJcrNode(node, STATE));
        Calendar calendar = this.getOptionalDatePropertyFromJcrNode(node, START_DATE);
        Calendar calendar2 = this.getOptionalDatePropertyFromJcrNode(node, COMPLETION_DATE);
        Calendar calendar3 = this.getOptionalDatePropertyFromJcrNode(node, LAST_MODIFICATION_DATE);
        String string2 = this.getPropertyFromJcrNode(node, LOG);
        int n = this.getIntegerPropertyFromJcrNode(node, FAILURE_COUNT);
        return new TaskStepInfo(string, stepState, calendar, calendar2, calendar3, string2, n);
    }

    private Node getTasksRootNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("tasks");
    }

    @Override
    public Collection<DeploymentTaskInfo> searchTasks(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        return this.searchTasks(archivedTaskSearchParameters, true);
    }

    @Override
    public Collection<DeploymentTaskInfo> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        return this.searchTasks(archivedTaskSearchParameters, false);
    }

    private List<DeploymentTaskInfo> searchTasks(final ArchivedTaskSearchParameters archivedTaskSearchParameters, final boolean bl) {
        return this.jcrTemplate.execute(new JcrCallback<List<DeploymentTaskInfo>>(){

            @Override
            public List<DeploymentTaskInfo> doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, archivedTaskSearchParameters);
                final ArrayList arrayList = Lists.newArrayList();
                JcrTaskArchive.this.mapQueryResultToDeploymentTasks(queryResult, bl, new TaskCallback(){

                    @Override
                    public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                        arrayList.add(deploymentTaskInfo);
                    }
                });
                return arrayList;
            }
        });
    }

    @Override
    public void searchTasks(ArchivedTaskSearchParameters archivedTaskSearchParameters, TaskCallback taskCallback) {
        this.searchTasks(archivedTaskSearchParameters, taskCallback, true);
    }

    @Override
    public void searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters archivedTaskSearchParameters, TaskCallback taskCallback) {
        this.searchTasks(archivedTaskSearchParameters, taskCallback, false);
    }

    private Object searchTasks(final ArchivedTaskSearchParameters archivedTaskSearchParameters, final TaskCallback taskCallback, final boolean bl) {
        return this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, archivedTaskSearchParameters);
                JcrTaskArchive.this.mapQueryResultToDeploymentTasks(queryResult, bl, taskCallback);
                return null;
            }
        });
    }

    private QueryResult executeJcrQuery(Session session, ArchivedTaskSearchParameters archivedTaskSearchParameters) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        JcrArchivedTaskSearchQueryBuilder jcrArchivedTaskSearchQueryBuilder = new JcrArchivedTaskSearchQueryBuilder(queryManager, session.getValueFactory(), archivedTaskSearchParameters);
        QueryObjectModel queryObjectModel = jcrArchivedTaskSearchQueryBuilder.buildQuery();
        return queryObjectModel.execute();
    }

    private void mapQueryResultToDeploymentTasks(QueryResult queryResult, boolean bl, TaskCallback taskCallback) throws RepositoryException {
        RowIterator rowIterator = queryResult.getRows();
        while (rowIterator.hasNext()) {
            try {
                Node node = rowIterator.nextRow().getNode("task");
                DeploymentTaskInfo deploymentTaskInfo = this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(node);
                if (bl) {
                    deploymentTaskInfo.setSteps(this.loadTaskStepInfosForJcrTaskNode(node));
                }
                taskCallback.doWithTask(deploymentTaskInfo);
            }
            catch (RepositoryException repositoryException) {}
        }
    }

    @Override
    public List<String> getAllTaskIds() {
        return this.jcrTemplate.execute(new JcrCallback<List<String>>(){

            @Override
            public List<String> doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, new ArchivedTaskSearchParameters());
                return JcrTaskArchive.this.mapQueryResultToTasksIds(queryResult);
            }
        });
    }

    private List<String> mapQueryResultToTasksIds(QueryResult queryResult) throws RepositoryException {
        ArrayList arrayList = Lists.newArrayList();
        RowIterator rowIterator = queryResult.getRows();
        while (rowIterator.hasNext()) {
            try {
                arrayList.add(this.getPropertyFromJcrNode(rowIterator.nextRow().getNode("task"), "$id"));
            }
            catch (RepositoryException repositoryException) {}
        }
        return arrayList;
    }

    @Override
    public Collection<Map<String, Object>> searchTasksWithoutLoadingSteps(final ArchivedTaskSearchParameters archivedTaskSearchParameters, final GroupBy groupBy) {
        return (Collection)this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Collection<Map<String, Object>> doInJcr(Session session) throws IOException, RepositoryException {
                RowIterator rowIterator = JcrTaskArchive.this.executeJcrQuery(session, archivedTaskSearchParameters).getRows();
                while (rowIterator.hasNext()) {
                    Node node = rowIterator.nextRow().getNode("task");
                    groupBy.process(JcrTaskArchive.this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(node));
                }
                return groupBy.getResult();
            }
        });
    }

    public static interface TaskCallback {
        public void doWithTask(DeploymentTaskInfo var1);
    }
}

