/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.AbstractChannel;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.transport.TransportException;

public abstract class AbstractDirectChannel
extends AbstractChannel
implements Channel.Direct {
    protected AbstractDirectChannel(Connection conn, String type) {
        super(conn, type);
        conn.attach(this);
    }

    @Override
    public void open() throws ConnectionException, TransportException {
        this.trans.write(this.buildOpenReq());
        this.open.await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    private void gotOpenConfirmation(SSHPacket buf) throws ConnectionException {
        try {
            this.init(buf.readUInt32AsInt(), buf.readUInt32AsInt(), buf.readUInt32AsInt());
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
        this.open.set();
    }

    private void gotOpenFailure(SSHPacket buf) throws ConnectionException {
        try {
            this.open.deliverError(new OpenFailException(this.getType(), buf.readUInt32AsInt(), buf.readString()));
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
        this.finishOff();
    }

    protected SSHPacket buildOpenReq() {
        return (SSHPacket)((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.CHANNEL_OPEN).putString(this.getType())).putUInt32(this.getID())).putUInt32(this.getLocalWinSize())).putUInt32(this.getLocalMaxPacketSize());
    }

    @Override
    protected void gotUnknown(Message cmd, SSHPacket buf) throws ConnectionException, TransportException {
        switch (cmd) {
            case CHANNEL_OPEN_CONFIRMATION: {
                this.gotOpenConfirmation(buf);
                break;
            }
            case CHANNEL_OPEN_FAILURE: {
                this.gotOpenFailure(buf);
                break;
            }
            default: {
                super.gotUnknown(cmd, buf);
            }
        }
    }
}

