/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

class CifsFile
extends BaseOverthereFile<CifsConnection> {
    private SmbFile smbFile;

    protected CifsFile(CifsConnection cifsConnection, SmbFile smbFile) {
        super(cifsConnection);
        this.smbFile = smbFile;
    }

    protected SmbFile getSmbFile() {
        return this.smbFile;
    }

    @Override
    public String getPath() {
        return ((CifsConnection)this.connection).encoder.fromUncPath(this.smbFile.getUncPath());
    }

    @Override
    public String getName() {
        return this.smbFile.getName();
    }

    @Override
    public OverthereFile getParentFile() {
        try {
            return new CifsFile((CifsConnection)this.getConnection(), new SmbFile(this.smbFile.getParent(), ((CifsConnection)this.connection).authentication));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        try {
            return this.smbFile.exists();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine existence of " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be read: " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be written: " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " can be executed: " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean isFile() throws RuntimeIOException {
        try {
            return this.smbFile.isFile();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is a directory: " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is a directory: " + smbException.toString(), smbException);
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.smbFile.isHidden();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine whether " + this + " is hidden: " + smbException.toString(), smbException);
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.smbFile.lastModified();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine last modification timestamp of " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public long length() throws RuntimeIOException {
        try {
            return this.smbFile.length();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot determine length of file " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public List<OverthereFile> listFiles() throws RuntimeIOException {
        try {
            this.upgradeToDirectorySmbFile();
            ArrayList arrayList = Lists.newArrayList();
            for (String string : this.smbFile.list()) {
                arrayList.add(this.getFile(string));
            }
            return arrayList;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + malformedURLException.toString(), malformedURLException);
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        try {
            this.smbFile.mkdir();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot create directory " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        try {
            this.smbFile.mkdirs();
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot create directories " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public void renameTo(OverthereFile overthereFile) throws RuntimeIOException {
        if (overthereFile instanceof CifsFile) {
            SmbFile smbFile = ((CifsFile)overthereFile).getSmbFile();
            try {
                this.smbFile.renameTo(smbFile);
            }
            catch (SmbException smbException) {
                throw new RuntimeIOException("Cannot move/rename " + this + " to " + overthereFile + ": " + smbException.toString(), smbException);
            }
        } else {
            throw new RuntimeIOException("Cannot move/rename cifs:" + ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-cifs:" + ((CifsConnection)this.connection).cifsConnectionType.toString().toLowerCase() + ": file/directory " + overthereFile);
        }
    }

    @Override
    public void setExecutable(boolean bl) {
    }

    @Override
    public void delete() throws RuntimeIOException {
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
                if (this.smbFile.list().length > 0) {
                    throw new RuntimeIOException("Cannot delete non-empty directory " + this);
                }
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + malformedURLException.toString(), malformedURLException);
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        try {
            if (this.smbFile.isDirectory()) {
                this.upgradeToDirectorySmbFile();
            }
            this.smbFile.delete();
            this.refreshSmbFile();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + malformedURLException.toString(), malformedURLException);
        }
        catch (SmbException smbException) {
            throw new RuntimeIOException("Cannot delete " + this + ": " + smbException.toString(), smbException);
        }
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        try {
            return this.smbFile.getInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + iOException.toString(), iOException);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return this.smbFile.getOutputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot open " + this + " for writing: " + iOException.toString(), iOException);
        }
    }

    private void upgradeToDirectorySmbFile() throws MalformedURLException {
        if (!this.smbFile.getPath().endsWith("/")) {
            this.smbFile = new SmbFile(this.smbFile.getURL() + "/", ((CifsConnection)this.connection).authentication);
        }
    }

    private void refreshSmbFile() throws MalformedURLException {
        this.smbFile = new SmbFile(this.smbFile.getPath(), ((CifsConnection)this.connection).authentication);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CifsFile)) {
            return false;
        }
        return this.getPath().equals(((CifsFile)object).getPath());
    }

    public int hashCode() {
        return this.smbFile.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getConnection() + "/" + this.getPath();
    }
}

