/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.telnet;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsTelnetConnection
extends CifsConnection {
    private static final String DETECTABLE_WINDOWS_PROMPT = "TELNET4OVERTHERE ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    public static final int EXITCODE_CANNOT_DETERMINE_ERRORLEVEL = -999999;
    private static Logger logger = LoggerFactory.getLogger(CifsTelnetConnection.class);

    public CifsTelnetConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper, true);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
    }

    @Override
    public OverthereProcess startProcess(final CmdLine cmdLine) {
        final String string = cmdLine.toCommandLine(this.getHostOperatingSystem(), false);
        try {
            final TelnetClient telnetClient = new TelnetClient();
            telnetClient.setConnectTimeout(this.connectionTimeoutMillis);
            telnetClient.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            logger.info("Connecting to telnet://{}@{}", (Object)this.username, (Object)this.address);
            telnetClient.connect(this.address, this.port);
            final InputStream inputStream = telnetClient.getInputStream();
            final OutputStream outputStream = telnetClient.getOutputStream();
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            final int[] nArray = new int[]{-999999};
            final Thread thread = new Thread("Process handler reader for command " + cmdLine){

                @Override
                public void run() {
                    try {
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, "ogin:");
                        CifsTelnetConnection.this.send(outputStream, CifsTelnetConnection.this.username);
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, "assword:");
                        CifsTelnetConnection.this.send(outputStream, CifsTelnetConnection.this.password);
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, ">", "ogon failure");
                        CifsTelnetConnection.this.send(outputStream, "PROMPT TELNET4OVERTHERE ");
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        if (CifsTelnetConnection.this.workingDirectory != null) {
                            CifsTelnetConnection.this.send(outputStream, "CD " + CifsTelnetConnection.this.workingDirectory.getPath());
                            CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        }
                        CifsTelnetConnection.this.send(outputStream, string);
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.this.send(outputStream, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        CifsTelnetConnection.this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        String string3 = byteArrayOutputStream.toString();
                        int n = string3.indexOf(CifsTelnetConnection.ERRORLEVEL_PREAMBLE);
                        int n2 = string3.indexOf(CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        if (n >= 0 && n2 >= 0) {
                            String string2 = string3.substring(n + CifsTelnetConnection.ERRORLEVEL_PREAMBLE.length(), n2);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Errorlevel string found: " + string2);
                            }
                            try {
                                nArray[0] = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                logger.error("Cannot parse errorlevel in Windows output: " + byteArrayOutputStream);
                            }
                        } else {
                            logger.error("Cannot find errorlevel in Windows output: " + byteArrayOutputStream);
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeIOException("Cannot start process " + cmdLine, iOException);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)pipedOutputStream);
                    }
                }
            };
            thread.start();
            return new OverthereProcess(){

                @Override
                public OutputStream getStdin() {
                    return outputStream;
                }

                @Override
                public InputStream getStdout() {
                    return pipedInputStream;
                }

                @Override
                public InputStream getStderr() {
                    return new ByteArrayInputStream(new byte[0]);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int waitFor() {
                    try {
                        try {
                            thread.join();
                        }
                        finally {
                            this.destroy();
                        }
                        return nArray[0];
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeIOException("Cannot execute command " + cmdLine + " on " + CifsTelnetConnection.this.address, interruptedException);
                    }
                }

                @Override
                public void destroy() {
                    if (telnetClient.isConnected()) {
                        try {
                            telnetClient.disconnect();
                            logger.info("Disconnected from telnet://{}@{}", (Object)CifsTelnetConnection.this.username, (Object)CifsTelnetConnection.this.address);
                            Closeables.closeQuietly((Closeable)pipedOutputStream);
                        }
                        catch (IOException iOException) {
                            throw new RuntimeIOException("Cannot disconnect from telnet://" + CifsTelnetConnection.this.username + "@" + CifsTelnetConnection.this.address, iOException);
                        }
                    }
                }
            };
        }
        catch (InvalidTelnetOptionException invalidTelnetOptionException) {
            throw new RuntimeIOException("Cannot execute command " + cmdLine + " at telnet://" + this.username + "@" + this.address, invalidTelnetOptionException);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot execute command " + cmdLine + " at telnet://" + this.username + "@" + this.address, iOException);
        }
    }

    private void receive(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, PipedOutputStream pipedOutputStream, String string) throws IOException {
        this.receive(inputStream, byteArrayOutputStream, pipedOutputStream, string, null);
    }

    private void receive(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, PipedOutputStream pipedOutputStream, String string, String string2) throws IOException {
        String string3;
        String string4;
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n;
            if ((n = inputStream.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            byteArrayOutputStream.write(n);
            string4 = byteArrayOutputStream.toString();
            char c = (char)n;
            switch (c) {
                case '\r': {
                    this.handleReceivedLine(byteArrayOutputStream, string4, pipedOutputStream);
                    break;
                }
                case '\n': {
                    if (bl) break;
                    this.handleReceivedLine(byteArrayOutputStream, string4, pipedOutputStream);
                    break;
                }
                case '[': {
                    if (!bl2) break;
                    throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (tlntadmn config mode=stream).");
                }
            }
            bl = c == '\r';
            boolean bl3 = bl2 = c == '\u001b';
            if (string2 == null || string4.length() < string2.length() || !(string3 = string4.substring(string4.length() - string2.length(), string4.length())).equals(string2)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected string \"" + string2 + "\" found in Windows Telnet output");
            }
            throw new IOException("Unexpected string \"" + string2 + "\" found in Windows Telnet output");
        } while (string4.length() < string.length() || !(string3 = string4.substring(string4.length() - string.length(), string4.length())).equals(string));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected string \"" + string + "\" found in Windows Telnet output");
        }
    }

    private void handleReceivedLine(ByteArrayOutputStream byteArrayOutputStream, String string, PipedOutputStream pipedOutputStream) throws IOException {
        if (!string.contains(DETECTABLE_WINDOWS_PROMPT)) {
            pipedOutputStream.write(byteArrayOutputStream.toByteArray());
            pipedOutputStream.flush();
        }
        byteArrayOutputStream.reset();
    }

    private void send(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = (string + "\r\n").getBytes();
        outputStream.write(byArray);
        outputStream.flush();
    }
}

