/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.conversion.StringCoder;
import com.xebialabs.deployit.plugin.api.utils.Strings;
import com.xebialabs.deployit.util.PasswordObfuscator;
import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitConfig {
    public static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    public static final String SPRING_CONFIG = "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml";
    public static final String DEFAULT_WEBCONTENT_PACKAGE = "web";
    public static final String DEFAULT_WEB_CONTEXT_ROOT = "/";
    public static final String DEFAULT_ADMIN_PASSWORD = "admin";
    public static final String KEY_USE_SSL = "ssl";
    public static final String KEY_SSL_PROTOCOL = "ssl.protocol";
    public static final String KEY_KEYSTORE_PATH = "keystore.path";
    public static final String KEY_KEYSTORE_PASSWORD = "keystore.password";
    public static final String KEY_KEYSTORE_KEYPASSWORD = "keystore.keypassword";
    public static final String KEY_HTTP_BIND_ADDRESS = "http.bind.address";
    public static final String KEY_HTTP_PORT = "http.port";
    public static final String KEY_HTTP_CONTEXT_ROOT = "http.context.root";
    public static final String KEY_JCR_REPOSITORY_PATH = "jcr.repository.path";
    public static final String KEY_IMPORTABLE_PACKAGES_PATH = "importable.packages.path";
    public static final String KEY_MINIMUM_THREADS = "threads.min";
    public static final String KEY_MAXIMUM_THREADS = "threads.max";
    public static final String KEY_DEFAULT_PREFIX = "default.";
    public static final String KEY_ADMIN_PASSWORD = "admin.password";
    public static final String KEY_CUSTOM_PREFIX = "custom.";
    protected String keyStorePath;
    protected String keyStorePassword;
    protected String keyStoreKeyPassword;
    private String httpBindAddress;
    protected int httpPort;
    private String webContextRoot = "/";
    protected String jcrRepositoryPath;
    protected String importablePackagesPath;
    protected boolean ssl;
    protected String sslProtocol;
    protected int minThreads;
    protected String adminPassword;
    private boolean dirty;
    protected int maxThreads;
    private boolean newConfiguration = true;
    private static final Logger logger = LoggerFactory.getLogger(DeployitConfig.class);

    public void load(Properties properties) {
        this.ssl = "true".equalsIgnoreCase(properties.getProperty(KEY_USE_SSL));
        this.sslProtocol = properties.getProperty(KEY_SSL_PROTOCOL);
        this.keyStorePath = properties.getProperty(KEY_KEYSTORE_PATH);
        this.keyStorePassword = properties.getProperty(KEY_KEYSTORE_PASSWORD);
        this.keyStoreKeyPassword = properties.getProperty(KEY_KEYSTORE_KEYPASSWORD);
        this.httpBindAddress = properties.getProperty(KEY_HTTP_BIND_ADDRESS, "localhost");
        this.httpPort = this.parseIntSilent(properties, KEY_HTTP_PORT, this.httpPort);
        this.webContextRoot = properties.getProperty(KEY_HTTP_CONTEXT_ROOT, this.webContextRoot);
        this.minThreads = this.parseIntSilent(properties, KEY_MINIMUM_THREADS, this.minThreads);
        this.maxThreads = this.parseIntSilent(properties, KEY_MAXIMUM_THREADS, this.maxThreads);
        this.jcrRepositoryPath = properties.getProperty(KEY_JCR_REPOSITORY_PATH);
        this.importablePackagesPath = properties.getProperty(KEY_IMPORTABLE_PACKAGES_PATH);
        this.adminPassword = properties.getProperty(KEY_ADMIN_PASSWORD, DEFAULT_ADMIN_PASSWORD);
        if (PasswordObfuscator.isEncrypted(this.adminPassword)) {
            this.adminPassword = PasswordObfuscator.decrypt(this.adminPassword);
        } else {
            logger.info("Read plaintext password from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
        this.newConfiguration = false;
    }

    private int parseIntSilent(Properties properties, String KEY, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(KEY));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void save(Properties properties) {
        properties.setProperty(KEY_USE_SSL, Boolean.toString(this.isSsl()));
        if (this.isSsl()) {
            properties.setProperty(KEY_KEYSTORE_PATH, this.getKeyStorePath());
            properties.setProperty(KEY_KEYSTORE_PASSWORD, this.keyStorePassword);
            properties.setProperty(KEY_KEYSTORE_KEYPASSWORD, this.keyStoreKeyPassword);
            if (this.getSslProtocol() != null) {
                properties.setProperty(KEY_SSL_PROTOCOL, this.getSslProtocol());
            }
        }
        properties.setProperty(KEY_HTTP_BIND_ADDRESS, this.httpBindAddress);
        properties.setProperty(KEY_HTTP_PORT, Integer.toString(this.getHttpPort()));
        properties.setProperty(KEY_HTTP_CONTEXT_ROOT, this.webContextRoot);
        properties.setProperty(KEY_JCR_REPOSITORY_PATH, this.getJcrRepositoryPath());
        properties.setProperty(KEY_IMPORTABLE_PACKAGES_PATH, this.getImportablePackagesPath());
        properties.setProperty(KEY_MINIMUM_THREADS, Integer.toString(this.minThreads));
        properties.setProperty(KEY_MAXIMUM_THREADS, Integer.toString(this.maxThreads));
        properties.setProperty(KEY_ADMIN_PASSWORD, PasswordObfuscator.ensureEncrypted(this.adminPassword != null ? this.adminPassword : DEFAULT_ADMIN_PASSWORD));
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.isSsl()) {
            if (Strings.isBlank((String)this.getKeyStorePath())) {
                System.err.println("keystore.path must be set.");
                valid = false;
            } else if (!new File(this.getKeyStorePath()).exists()) {
                System.err.println("keystore.path must point to an existing keystore.");
                valid = false;
            }
        }
        valid &= this.checkSet(this.getHttpBindAddress(), KEY_HTTP_BIND_ADDRESS);
        valid &= this.validateThatIntIsBiggerThen(KEY_HTTP_PORT, this.getHttpPort(), 0);
        valid &= this.checkSet(this.getWebContextRoot(), KEY_HTTP_CONTEXT_ROOT);
        if (!this.getWebContextRoot().startsWith(DEFAULT_WEB_CONTEXT_ROOT)) {
            System.err.println("http.context.root should start with a '/'");
            valid = false;
        }
        valid &= this.checkSet(this.getJcrRepositoryPath(), KEY_JCR_REPOSITORY_PATH);
        valid &= this.checkSet(this.getImportablePackagesPath(), KEY_IMPORTABLE_PACKAGES_PATH);
        valid &= this.validateThatIntIsBiggerThen(KEY_MINIMUM_THREADS, this.getMinThreads(), 0);
        return valid &= this.validateThatIntIsBiggerThen(KEY_MAXIMUM_THREADS, this.getMaxThreads(), this.getMinThreads());
    }

    private boolean checkSet(String value, String key) {
        if (Strings.isBlank((String)value)) {
            System.err.println(key + " must be set.");
            return false;
        }
        return true;
    }

    private boolean validateThatIntIsBiggerThen(String key, int intToValidate, int shouldBeBiggerThen) {
        if (intToValidate <= shouldBeBiggerThen) {
            System.err.println(key + " is not valid, must be a number larger then " + shouldBeBiggerThen);
            return false;
        }
        return true;
    }

    public boolean isNewConfiguration() {
        return this.newConfiguration;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return StringCoder.decode(this.keyStorePassword);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = StringCoder.encode(keyStorePassword);
    }

    public String getKeyStoreKeyPassword() {
        return StringCoder.decode(this.keyStoreKeyPassword);
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = StringCoder.encode(keyStoreKeyPassword);
    }

    public String getHttpBindAddress() {
        return this.httpBindAddress;
    }

    public void setHttpBindAddress(String httpBindAddress) {
        this.httpBindAddress = httpBindAddress;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getJcrRepositoryPath() {
        return this.jcrRepositoryPath;
    }

    public void setJcrRepositoryPath(String jcrRepositoryPath) {
        this.jcrRepositoryPath = jcrRepositoryPath;
    }

    public String getImportablePackagesPath() {
        return this.importablePackagesPath;
    }

    public void setImportablePackagesPath(String setImportablePackagesPath) {
        this.importablePackagesPath = setImportablePackagesPath;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getWebContextRoot() {
        return this.webContextRoot;
    }

    public void setWebContextRoot(String webContextRoot) {
        this.webContextRoot = webContextRoot;
    }
}

