/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployableConfigurationItemReader {
    static final String NAMESPACE_SEPARATOR = "/";
    static final String CI = "CI-";
    static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    private final Map<String, Attributes> entries;
    private static final Logger logger = LoggerFactory.getLogger(DeployableConfigurationItemReader.class);

    public DeployableConfigurationItemReader(Map<String, Attributes> entries) {
        this.entries = entries;
    }

    public Deployable readMiddlewareConfiguration(DeploymentPackage deploymentPackage, Map.Entry<String, Attributes> entry) {
        String entryName = entry.getKey().trim();
        Attributes entryAttributes = entry.getValue();
        String configurationItemType = this.readCIType(entryAttributes, entryName);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        Deployable configurationItem = (Deployable)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        configurationItem.setId(baseId + NAMESPACE_SEPARATOR + this.getDeployableNameFromEntryName(entryName));
        this.fillAttributes(configurationItem, descriptor, entryAttributes, baseId);
        return configurationItem;
    }

    public boolean isMiddlewareResource(Map.Entry<String, Attributes> entry) {
        String configurationItemType = entry.getValue().getValue(TYPE_ATTRIBUTE_NAME);
        String entryName = entry.getKey().trim();
        if (DeployableConfigurationItemReader.isBlank(configurationItemType)) {
            return false;
        }
        Descriptor configurationItemDescriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        Checks.checkArgument(configurationItemDescriptor.isAssignableTo(Deployable.class), "Configuration item %s of type %s is not Deployable", entryName, configurationItemType);
        return !configurationItemDescriptor.isAssignableTo(DeployableArtifact.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableArtifact readArtifact(DeploymentPackage deploymentPackage, ImportSource source, Map.Entry<String, Attributes> entry, ImportingContext ctx) {
        String entryName = entry.getKey().trim();
        Attributes entryAttributes = entry.getValue();
        String configurationItemType = this.readCIType(entryAttributes, entryName);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(entryName, configurationItemType);
        DeployableArtifact artifact = (DeployableArtifact)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        artifact.setId(baseId + NAMESPACE_SEPARATOR + this.getDeployableName(entryName, entryAttributes));
        TFile sourceArchive = new TFile(source.getFile());
        try {
            TFile tempFolder = this.createTempFolderForImport(ctx, (Artifact)artifact);
            TFile dest = DeployableConfigurationItemReader.copyArtifactData(sourceArchive, entryName, tempFolder, artifact, baseId);
            logger.debug("Adding {} {} to deployment package", (Object)descriptor.getType(), (Object)dest);
            artifact.setFile(LocalFile.valueOf((File)dest.getFile()));
            this.fillAttributes((Deployable)artifact, descriptor, entryAttributes, baseId);
            DeployableArtifact deployableArtifact = artifact;
            return deployableArtifact;
        }
        finally {
            if (sourceArchive.isArchive()) {
                try {
                    TFile.umount((TFile)sourceArchive);
                }
                catch (FsSyncException e) {
                    logger.error("Unable to release resources for archive {}", (Object)sourceArchive.getName());
                    logger.error("Following exception occurred while trying to release resources: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static TFile copyArtifactData(TFile sourceArchive, String entryName, TFile tempFolder, DeployableArtifact artifact, String baseId) {
        TFile artifactFile = new TFile((File)sourceArchive, entryName, TArchiveDetector.NULL);
        if (!artifactFile.exists()) {
            throw new RuntimeIOException(String.format("The entry %s could not be found in the importable package %s.", entryName, baseId));
        }
        TFile dest = new TFile((File)tempFolder, artifactFile.getName());
        try {
            artifactFile.cp_r((File)dest);
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Could not copy %s to %s while importing %s", artifactFile, dest, artifact.getId()), e);
        }
        return dest;
    }

    private TFile createTempFolderForImport(ImportingContext ctx, Artifact artifact) {
        try {
            String name = "temp-" + artifact.getName();
            TFile tempFolder = new TFile(File.createTempFile(name, "")).rm().mkdir(false);
            ((List)ctx.getAttribute("temporaryFiles")).add(tempFolder);
            logger.debug("Created Temporary folder {}", (Object)tempFolder);
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String getDeployableName(String entryName, Attributes entryAttributes) {
        String name = entryAttributes.getValue(NAME_ATTRIBUTE_NAME);
        if (name != null) {
            return name;
        }
        return this.getDeployableNameFromEntryName(entryName);
    }

    protected String getDeployableNameFromEntryName(String entryName) {
        String name;
        int index = entryName.lastIndexOf(NAMESPACE_SEPARATOR);
        if (index > -1) {
            if (++index >= entryName.length()) {
                throw new ImporterException("Could not determine artifact Name: %s because entry ends with '/'", entryName);
            }
            name = entryName.substring(index);
        } else {
            name = entryName;
        }
        return name;
    }

    private String readCIType(Attributes entryAttributes, String entryName) {
        String configurationItemTypeShortName = entryAttributes.getValue(TYPE_ATTRIBUTE_NAME);
        if (DeployableConfigurationItemReader.isBlank(configurationItemTypeShortName)) {
            throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", entryName, TYPE_ATTRIBUTE_NAME);
        }
        return configurationItemTypeShortName;
    }

    private Descriptor getDescriptorForConfigurationItem(String entryName, String configurationItemTypeShortName) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)configurationItemTypeShortName);
        if (descriptor == null) {
            throw new ImporterException("Could not import Name: %s because %s is not a known CI type", entryName, configurationItemTypeShortName);
        }
        return descriptor;
    }

    private static boolean isBlank(String packageFormatVersion) {
        return Strings.nullToEmpty((String)packageFormatVersion).trim().isEmpty();
    }

    void fillAttributes(Deployable entity, Descriptor configurationItemDescriptor, Attributes entryAttributes, String baseId) {
        block9: for (PropertyDescriptor propertyDescriptor : configurationItemDescriptor.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    String value = entryAttributes.getValue(CI + name);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)value);
                    continue block9;
                }
                case CI: {
                    String mfName = entryAttributes.getValue(CI + name);
                    if (mfName == null) continue block9;
                    Deployable configurationItem = this.convertReference(baseId, mfName);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)configurationItem);
                    continue block9;
                }
                case SET_OF_STRING: {
                    HashSet stringsSet = Sets.newHashSet(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, entryAttributes));
                    if (stringsSet.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)stringsSet);
                    continue block9;
                }
                case SET_OF_CI: {
                    HashSet setOfCis = Sets.newHashSet(this.transformCollectionOfCis(entryAttributes, baseId, propertyDescriptor));
                    if (setOfCis.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)setOfCis);
                    continue block9;
                }
                case LIST_OF_STRING: {
                    ArrayList stringsList = Lists.newArrayList(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, entryAttributes));
                    if (stringsList.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)stringsList);
                    continue block9;
                }
                case LIST_OF_CI: {
                    ArrayList listOfCis = Lists.newArrayList(this.transformCollectionOfCis(entryAttributes, baseId, propertyDescriptor));
                    if (listOfCis.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)listOfCis);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    String keyStart = (CI + propertyDescriptor.getName() + "-").toLowerCase();
                    for (Object attributeKey : entryAttributes.keySet()) {
                        String s = attributeKey.toString();
                        if (!s.toLowerCase().startsWith(keyStart)) continue;
                        String mapKey = s.substring(keyStart.length());
                        String mapValue = entryAttributes.getValue(s);
                        map.put(mapKey, mapValue);
                    }
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)map);
                    continue block9;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private Deployable convertReference(String baseId, String mfName) {
        Attributes referencedAttrs = Checks.checkNotNull(this.entries.get(mfName), "Couldn't find the referenced entry [%s], are you using the entry Name?", mfName);
        Type ciType = Type.valueOf((String)this.readCIType(referencedAttrs, mfName));
        Deployable configurationItem = (Deployable)ciType.getDescriptor().newInstance();
        String ciName = referencedAttrs.getValue(NAME_ATTRIBUTE_NAME);
        if (ciName == null) {
            ciName = mfName;
        }
        String id = IdGenerator.generateId((String)baseId, (String)ciName);
        configurationItem.setId(id);
        return configurationItem;
    }

    private Collection<Deployable> transformCollectionOfCis(Attributes entryAttributes, final String baseId, PropertyDescriptor propertyDescriptor) {
        return Collections2.transform(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, entryAttributes), (Function)new Function<String, Deployable>(){

            public Deployable apply(String from) {
                return DeployableConfigurationItemReader.this.convertReference(baseId, from);
            }
        });
    }

    private static Collection<String> handleCollectionOfStrings(PropertyDescriptor propertyDescriptor, Attributes entryAttributes) {
        String oldStyle = (CI + propertyDescriptor.getName() + "-EntryValue").toLowerCase();
        String key = (CI + propertyDescriptor.getName()).toLowerCase();
        HashSet strings = Sets.newHashSet();
        for (Map.Entry<Object, Object> entry : entryAttributes.entrySet()) {
            String entryKey = entry.getKey().toString().toLowerCase().trim();
            if (!entryKey.startsWith(oldStyle) && !entryKey.equals(key)) continue;
            strings.add(entry.getValue().toString());
        }
        return strings;
    }
}

