/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKeyManager;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.URI;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class KeyManagerController<D extends ZipDriver>
extends FsDecoratingController<FsModel, FsController<?>> {
    protected final D driver;
    private volatile KeyManager<?> manager;

    protected KeyManagerController(FsController<?> controller, D driver) {
        super(controller);
        if (null == driver) {
            throw new NullPointerException();
        }
        this.driver = driver;
    }

    protected abstract Class<?> getKeyType();

    protected abstract Class<? extends IOException> getKeyExceptionType();

    private KeyManager<?> getKeyManager() {
        KeyManager<?> manager = this.manager;
        if (null == manager) {
            this.manager = manager = ((ZipDriver)this.driver).getKeyManagerProvider().get(this.getKeyType());
        }
        return manager;
    }

    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        try {
            this.delegate.unlink(name, options);
        }
        catch (FsFalsePositiveException ex) {
            IOException cause = ex.getCause();
            if (null != cause && this.getKeyExceptionType().isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            throw ex;
        }
        if (name.isRoot()) {
            this.getKeyManager().removeKeyProvider(((ZipDriver)this.driver).resourceUri(this.getModel(), name.toString()));
        }
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.delegate.sync(options, handler);
        KeyManager<?> manager = this.getKeyManager();
        URI resource = ((ZipDriver)this.driver).mountPointUri(this.getModel());
        KeyProvider<Object> provider = manager instanceof SafeKeyManager ? ((SafeKeyManager)manager).getMappedKeyProvider(resource) : manager.getKeyProvider(resource);
        if (null != provider) {
            ((ZipDriver)this.driver).getKeyProviderSyncStrategy().sync(provider);
        }
    }
}

