/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalContext {
    private static final Logger logger = LoggerFactory.getLogger(GlobalContext.class);
    private static final Map<String, Value> context = new MapMaker().makeComputingMap((Function)new Function<String, Value>(){

        public Value apply(String input) {
            return new Value("", null);
        }
    });
    public static final File DEFAULTS = new File("conf", "deployit-defaults.properties");

    private GlobalContext() {
    }

    static void register(PropertyDescriptor pd, String defaultValue) {
        if (defaultValue == null && !pd.isHidden()) {
            return;
        }
        context.put(GlobalContext.constructPropertyName(pd), new Value(pd.getDescription(), defaultValue));
    }

    public static void register(PropertyDescriptor pd, PropertyDescriptor inheritedFrom) {
        context.put(GlobalContext.constructPropertyName(pd), new InheritedValue(pd.getDescription(), GlobalContext.constructPropertyName(inheritedFrom), pd.isHidden()));
    }

    private static String constructPropertyName(PropertyDescriptor pd) {
        return pd.getDeclaringDescriptor().getType() + "." + pd.getName();
    }

    static String lookup(PropertyDescriptor pd) {
        return GlobalContext.lookup(GlobalContext.constructPropertyName(pd));
    }

    private static String lookup(String key) {
        if (!context.containsKey(key)) {
            return null;
        }
        return context.get(key).getValue();
    }

    static void loadStoredDefaults(File configFile) {
        if (!configFile.exists()) {
            logger.info("Could not find '" + configFile + "', continuing without loading defaults");
            return;
        }
        if (configFile.isDirectory()) {
            logger.error(configFile + " is a directory but should be a plain file, aborting!");
            throw new IllegalStateException("Please remove " + configFile + " and try again.");
        }
        try {
            Files.readLines((File)configFile, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Object>(){

                public boolean processLine(String line) throws IOException {
                    if (!line.startsWith("#") && line.contains("=")) {
                        int i = line.indexOf("=");
                        String key = line.substring(0, i);
                        Value value = (Value)context.get(key);
                        context.put(key, new ExplicitValue(value.description, line.substring(i + 1)));
                    }
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + configFile.toString() + "'", e);
        }
    }

    public static void storeDefaults() {
        GlobalContext.storeDefaults(DEFAULTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void storeDefaults(File configFile) {
        block11: {
            BufferedWriter bufferedWriter;
            block10: {
                bufferedWriter = null;
                if (configFile.getParentFile().exists() && configFile.getParentFile().isDirectory()) break block10;
                logger.warn("Not writing {} because the directory does not exist", (Object)configFile);
                Closeables.closeQuietly(bufferedWriter);
                return;
            }
            try {
                bufferedWriter = Files.newWriter((File)configFile, (Charset)Charset.defaultCharset());
                ArrayList keys = Lists.newArrayList(context.keySet());
                Collections.sort(keys);
                for (String k : keys) {
                    Value v = context.get(k);
                    if (!v.isShouldWrite()) continue;
                    if (!Strings.isNullOrEmpty((String)v.description)) {
                        bufferedWriter.append("# ").append(v.description);
                        if (v instanceof InheritedValue) {
                            InheritedValue inheritedValue = (InheritedValue)v;
                            bufferedWriter.append(" (inherited from: ").append(inheritedValue.superTypeProperty).append(")");
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.append(v.isExplicit() ? "" : "#").append(k).append('=').append(v.getValue());
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Could not start writing to '" + configFile + "'", (Throwable)e);
                Closeables.closeQuietly((Closeable)bufferedWriter);
                break block11;
            }
            catch (IOException e2) {
                logger.error("Could not write to '" + configFile + "'", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(bufferedWriter);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly((Closeable)bufferedWriter);
            }
            Closeables.closeQuietly((Closeable)bufferedWriter);
        }
    }

    static void validateValues() {
        boolean valid = true;
        ArrayList messages = Lists.newArrayList();
        for (String prop : context.keySet()) {
            PropertyDescriptor propertyDescriptor;
            Descriptor descriptor;
            int i = prop.lastIndexOf(46);
            String type = prop.substring(0, i);
            String propertyName = prop.substring(i + 1);
            Type tType = Type.valueOf(type);
            if (!DescriptorRegistry.exists(tType) || (descriptor = DescriptorRegistry.getDescriptor(tType)).isVirtual() || (propertyDescriptor = descriptor.getPropertyDescriptor(propertyName)) == null) continue;
            try {
                propertyDescriptor.getDefaultValue();
                if (!propertyDescriptor.isRequired() || !propertyDescriptor.isHidden() || !Strings.isNullOrEmpty((String)GlobalContext.lookup(propertyDescriptor))) continue;
                valid = false;
                messages.add(String.format("Cannot register empty default value for hidden required property [%s]", prop));
            }
            catch (RuntimeException re) {
                valid = false;
                messages.add(String.format("Incorrect default registered: [%s] with value %s", prop, context.get(prop).getValue()));
            }
        }
        if (!valid) {
            String join = Joiner.on((String)"\n").join((Iterable)messages);
            logger.error(join);
            throw new IllegalStateException("Could not initialize the default values, please look at the log and correct the defaults file: " + DEFAULTS + "\n" + join);
        }
    }

    static class ExplicitValue
    extends Value {
        ExplicitValue(String description, String value) {
            super(description, value);
        }

        @Override
        boolean isExplicit() {
            return true;
        }
    }

    static class Value {
        final String description;
        final String value;

        Value(String description, String value) {
            this.description = description;
            this.value = value;
        }

        boolean isExplicit() {
            return false;
        }

        boolean isShouldWrite() {
            return true;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class InheritedValue
    extends Value {
        private final String superTypeProperty;
        private final boolean shouldWrite;

        InheritedValue(String description, String superTypeProperty, boolean shouldWrite) {
            super(description, "");
            this.superTypeProperty = superTypeProperty;
            this.shouldWrite = shouldWrite;
        }

        @Override
        public String getValue() {
            return GlobalContext.lookup(this.superTypeProperty);
        }

        @Override
        boolean isShouldWrite() {
            return this.shouldWrite;
        }
    }
}

