/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.commons.iterator.FilteringNodeIterator;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexNodeResolver
extends NodeResolver {
    private static Logger log = LoggerFactory.getLogger(IndexNodeResolver.class);
    private final QueryManager queryManager;

    IndexNodeResolver(Session session, NamePathResolver resolver) throws RepositoryException {
        super(session, resolver);
        this.queryManager = session.getWorkspace().getQueryManager();
    }

    @Override
    public Node findNode(Name nodeName, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(nodeName, ntName);
        query.setLimit(1L);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    @Override
    public Node findNode(Name propertyName, String value, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(value, Collections.singleton(propertyName), ntName, true, 1L);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    @Override
    public NodeIterator findNodes(Set<Name> propertyNames, String value, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        Query query = this.buildQuery(value, propertyNames, ntName, exact, maxSize);
        return query.execute().getNodes();
    }

    @Override
    public NodeIterator findNodes(Path relPath, String value, int authorizableType, boolean exact, long maxSize) throws RepositoryException {
        Query query;
        if (relPath.getLength() == 1) {
            Set<Name> names = Collections.singleton(relPath.getName());
            query = this.buildQuery(value, names, null, exact, maxSize, this.getSearchRoot(authorizableType));
        } else {
            query = this.buildQuery(value, relPath, exact, maxSize, this.getSearchRoot(authorizableType));
        }
        return new ResultFilteringNodeIterator(query.execute().getNodes(), this.getAuthorizableTypePredicate(authorizableType, false));
    }

    private Query buildQuery(Name nodeName, Name ntName) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append(this.getSearchRoot(ntName));
        stmt.append("//element(");
        stmt.append(ISO9075.encode((String)this.getNamePathResolver().getJCRName(nodeName)));
        stmt.append(",");
        stmt.append(this.getNamePathResolver().getJCRName(ntName));
        stmt.append(")");
        return this.queryManager.createQuery(stmt.toString(), "xpath");
    }

    private Query buildQuery(String value, Set<Name> props, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        String searchRoot = this.getSearchRoot(ntName);
        return this.buildQuery(value, props, ntName, exact, maxSize, searchRoot);
    }

    private Query buildQuery(String value, Set<Name> props, Name ntName, boolean exact, long maxSize, String searchRoot) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        if (!"/".equals(searchRoot)) {
            stmt.append(searchRoot);
        }
        if (ntName != null) {
            stmt.append("//element(*,");
            stmt.append(this.getNamePathResolver().getJCRName(ntName));
        } else {
            stmt.append("//element(*");
        }
        if (value == null) {
            stmt.append(")");
        } else {
            stmt.append(")[");
            int i = 0;
            for (Name prop : props) {
                stmt.append(exact ? "@" : "jcr:like(@");
                String pName = this.getNamePathResolver().getJCRName(prop);
                stmt.append(ISO9075.encode((String)pName));
                if (exact) {
                    stmt.append("='");
                    stmt.append(value.replaceAll("'", "''"));
                    stmt.append("'");
                } else {
                    stmt.append(",'%");
                    stmt.append(IndexNodeResolver.escapeForQuery(value));
                    stmt.append("%')");
                }
                if (++i >= props.size()) continue;
                stmt.append(" or ");
            }
            stmt.append("]");
        }
        Query q = this.queryManager.createQuery(stmt.toString(), "xpath");
        q.setLimit(maxSize);
        return q;
    }

    private Query buildQuery(String value, Path relPath, boolean exact, long maxSize, String searchRoot) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        if (!"/".equals(searchRoot)) {
            stmt.append(searchRoot);
        }
        String p = this.getNamePathResolver().getJCRPath(relPath.getAncestor(1));
        stmt.append("//").append(p);
        if (value != null) {
            stmt.append("[");
            Name prop = relPath.getName();
            stmt.append(exact ? "@" : "jcr:like(@");
            String pName = this.getNamePathResolver().getJCRName(prop);
            stmt.append(ISO9075.encode((String)pName));
            if (exact) {
                stmt.append("='");
                stmt.append(value.replaceAll("'", "''"));
                stmt.append("'");
            } else {
                stmt.append(",'%");
                stmt.append(IndexNodeResolver.escapeForQuery(value));
                stmt.append("%')");
            }
            stmt.append("]");
        }
        Query q = this.queryManager.createQuery(stmt.toString(), "xpath");
        q.setLimit(maxSize);
        return q;
    }

    private static String escapeForQuery(String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("''");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private class ResultFilteringNodeIterator
    extends FilteringNodeIterator {
        private Set<String> authorizableIDs;

        private ResultFilteringNodeIterator(NodeIterator base, NodeResolver.AuthorizableTypePredicate filter) {
            super(base, (Predicate)filter);
        }

        protected Node seekNext() {
            if (this.authorizableIDs == null) {
                this.authorizableIDs = new HashSet<String>();
            }
            Node n = null;
            while (n == null && this.base.hasNext()) {
                NodeImpl nextRes = (NodeImpl)this.base.nextNode();
                Node authorizableNode = ((NodeResolver.AuthorizableTypePredicate)this.filter).getAuthorizableNode(nextRes);
                try {
                    if (authorizableNode == null || !this.authorizableIDs.add(authorizableNode.getIdentifier())) continue;
                    n = authorizableNode;
                }
                catch (RepositoryException e) {
                    log.warn(e.getMessage());
                }
            }
            return n;
        }
    }
}

