/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.deployed.ExecutedScript;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;

@Metadata(virtual=true, description="A script executed on a generic container whose deployable artifact supports placeholder replacement")
@Placeholders
public class ExecutedScriptWithDerivedArtifact<D extends DeployableArtifact>
extends ExecutedScript<D>
implements DerivedArtifact<D> {
    @Property(required=false, category="Placeholders", description="A key/value pair mapping of placeholders in the deployed artifact to their values. Special values are <ignore> and <empty>")
    private Map<String, String> placeholders = Maps.newHashMap();
    private OverthereFile placeholderProcessedFile;

    @Override
    protected OverthereFile getArtifactIfPresent() {
        return this.placeholderProcessedFile;
    }

    public D getSourceArtifact() {
        return (D)((DeployableArtifact)this.getDeployable());
    }

    public void initFile(PlaceholderReplacer replacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)replacer);
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }
}

