/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.util.Option;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class PermissionEnforcer {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    private JcrTemplate jcrTemplate;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermissionEnforcer.class);

    @Autowired
    public PermissionEnforcer(JcrTemplate jcrTemplate, RoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public boolean hasPermission(Authentication authentication, Permission ... permissions) {
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission ... permissions) {
        Authentication authentication = Permissions.getAuthentication();
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission permission, String onConfigurationItem) {
        return this.hasLoggedInUserPermission(Lists.newArrayList((Object[])new Permission[]{permission}), onConfigurationItem);
    }

    public boolean hasLoggedInUserPermission(List<Permission> permissions, String onConfigurationItem) {
        return this.hasPermission(Permissions.getAuthentication(), permissions, onConfigurationItem);
    }

    private boolean hasPermission(Authentication auth, List<Permission> permissions, String onConfigurationItem) {
        List<Role> allRoles;
        Collection<String> allPrincipals = Permissions.authenticationToPrincipals(auth);
        if (this.isAdmin(allPrincipals, allRoles = this.roleService.getRolesFor(auth))) {
            return true;
        }
        return this.checkPermission(permissions, onConfigurationItem, allRoles);
    }

    private boolean checkPermission(final List<Permission> permissions, final String onConfigurationItem, final List<Role> allRoles) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                if (Strings.nullToEmpty((String)onConfigurationItem).isEmpty()) {
                    return PermissionEnforcer.this.checkGlobalPermission(session, permissions, allRoles);
                }
                return PermissionEnforcer.this.checkCiPermission(session, permissions, onConfigurationItem, allRoles);
            }
        });
    }

    private boolean checkGlobalPermission(Session session, List<Permission> permissions, List<Role> allRoles) throws RepositoryException {
        Node node = session.getNode("/$configuration/security");
        Option<Boolean> o = this.checkPermission(node, permissions, allRoles);
        if (o.isSet()) {
            return o.get();
        }
        return false;
    }

    private boolean checkCiPermission(Session session, List<Permission> permissions, String onConfigurationItem, List<Role> allRoles) throws RepositoryException {
        List<String> nodes = this.nodesToInspect(onConfigurationItem);
        for (String nodeId : nodes) {
            Option<Boolean> o;
            if (!session.nodeExists(nodeId) || !(o = this.checkCiPermission(session.getNode(nodeId), permissions, allRoles)).isSet()) continue;
            return o.get();
        }
        return false;
    }

    private Option<Boolean> checkCiPermission(Node node, List<Permission> permissions, List<Role> allRoles) throws RepositoryException {
        if (!Permissions.isSecurable(node)) {
            return Option.none();
        }
        return this.checkPermission(node, permissions, allRoles);
    }

    private Option<Boolean> checkPermission(Node node, List<Permission> allPermissions, List<Role> allRoles) throws RepositoryException {
        logger.debug("Trying to read permissions from [{}]", (Object)node.getPath());
        Map<String, String> permissions = Permissions.readPermissionMap(node);
        if (permissions.isEmpty()) {
            logger.debug("[{}] has no permissions set, checking up the tree.", (Object)node.getPath());
            return Option.none();
        }
        logger.debug("[{}] has permissions enabled, which are: [{}]", (Object)node.getPath(), permissions);
        for (Permission permission : allPermissions) {
            Iterable<Integer> permittedRoles;
            if (!permissions.containsKey(permission.getPermissionName()) || !Iterables.any(permittedRoles = Permissions.splitRoles(permissions.get(permission.getPermissionName())), (Predicate)Predicates.in((Collection)Lists.newArrayList(Permissions.rolesToIds(allRoles))))) continue;
            return Option.some(true);
        }
        return Option.some(false);
    }

    private List<String> nodesToInspect(String onConfigurationItem) {
        return Lists.newArrayList((Iterable)Lists.transform(Permissions.getFullTreeAsSeparateNodesInChildToRootOrder(onConfigurationItem), (Function)new Function<String, String>(){

            public String apply(String input) {
                return JcrPathHelper.getAbsolutePathFromId(input);
            }
        }));
    }

    boolean isAdmin(Collection<String> allPrincipals, List<Role> allRoles) {
        Boolean isAdmin = allPrincipals.contains(ROLE_ADMIN) || this.checkPermission(Lists.newArrayList((Object[])new Permission[]{Permission.ADMIN}), "", allRoles);
        logger.debug("Admin privileges [{}] granted to {}", (Object)(isAdmin != false ? "are" : "are not"), allPrincipals);
        return isAdmin;
    }
}

