/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.authentication.RememberMe;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class BasicAuthWithRememberMeFilter
extends BasicAuthenticationFilter {
    public BasicAuthWithRememberMeFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        String header = request.getHeader("Authorization");
        String[] tokens = this.extractAndDecodeHeader(header, request);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)authResult.getName(), (Object)tokens[1], authResult.getAuthorities());
        token.setDetails(authResult.getDetails());
        if (request.getRequestURI().contains("logout")) {
            RememberMe.forget((Authentication)token);
        } else {
            RememberMe.remember((Authentication)token);
        }
    }

    private String[] extractAndDecodeHeader(String header, HttpServletRequest request) throws IOException {
        byte[] decoded;
        byte[] base64Token = header.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, this.getCredentialsCharset(request));
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }
}

