/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.checks.Checks;
import java.util.Calendar;

public class ArchivedTaskSearchParameters {
    protected Calendar startDate;
    protected Calendar endDate;
    protected String executedBy;
    protected String application;
    protected String version;
    protected String environment;
    protected String taskUuid;
    protected DateRange dateRangeSearch = DateRange.NONE;
    protected Status status = Status.ANY;

    public ArchivedTaskSearchParameters() {
    }

    protected ArchivedTaskSearchParameters(ArchivedTaskSearchParameters p) {
        this.startDate = p.startDate;
        this.endDate = p.endDate;
        this.executedBy = p.executedBy;
        this.application = p.application;
        this.version = p.version;
        this.environment = p.environment;
        this.dateRangeSearch = p.dateRangeSearch;
        this.status = p.status;
        this.taskUuid = p.taskUuid;
    }

    public ArchivedTaskSearchParameters executedByUser(String user) {
        this.executedBy = user;
        return this;
    }

    public ArchivedTaskSearchParameters createdBetween(Calendar startDate, Calendar endDate) {
        Checks.checkNotNull(startDate, "Start date cannot be null");
        Checks.checkNotNull(endDate, "End date cannot be null");
        this.dateRangeSearch = DateRange.BETWEEN;
        if (startDate.after(endDate)) {
            this.startDate = endDate;
            this.endDate = startDate;
        } else {
            this.startDate = startDate;
            this.endDate = endDate;
        }
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrBefore(Calendar endDate) {
        Checks.checkNotNull(endDate, "End date cannot be null");
        this.dateRangeSearch = DateRange.BEFORE;
        this.endDate = endDate;
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrAfter(Calendar startDate) {
        Checks.checkNotNull(startDate, "Start date cannot be null");
        this.dateRangeSearch = DateRange.AFTER;
        this.startDate = startDate;
        return this;
    }

    public ArchivedTaskSearchParameters forApplicationAndVersion(String application, String version) {
        this.application = application;
        this.version = version;
        return this;
    }

    public ArchivedTaskSearchParameters forApplication(String application) {
        return this.forApplicationAndVersion(application, null);
    }

    public ArchivedTaskSearchParameters toEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public ArchivedTaskSearchParameters thatWasCancelled() {
        this.status = Status.CANCELLED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompleted() {
        this.status = Status.COMPLETED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompletedAfterRetry() {
        this.status = Status.COMPLETED_AFTER_RETRY;
        return this;
    }

    public ArchivedTaskSearchParameters withUniqueId(String uuid) {
        this.taskUuid = uuid;
        return this;
    }

    public static enum Status {
        COMPLETED,
        CANCELLED,
        COMPLETED_AFTER_RETRY,
        ANY;

    }

    public static enum DateRange {
        AFTER,
        BEFORE,
        BETWEEN,
        NONE;

    }
}

