/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.comparison.Comparator;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class QueryResource
implements QueryProxy {
    public static final Predicate<ConfigurationItemData> hasReadRight = new Predicate<ConfigurationItemData>(){

        public boolean apply(ConfigurationItemData input) {
            return Permission.READ.getPermissionHandler().hasPermission(input.getId());
        }
    };
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private Comparator comparator;
    private static final Logger logger = LoggerFactory.getLogger(QueryResource.class);

    public Response list(@QueryParam(value="typeName") String typeName, @QueryParam(value="archetype") boolean archetype, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage, @QueryParam(value="property") List<PropertyValue> values, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, page, resultPerPage, values, parent, id);
        ConfigurationItemIds dto = new ConfigurationItemIds();
        Collection filter = Collections2.transform((Collection)Collections2.filter((Collection)this.repositoryService.list(searchParam), hasReadRight), DtoReader.ciDataToCiId);
        dto.getConfigurationItemIds().addAll(filter);
        return ResponseFactory.ok((Object)dto).build();
    }

    public Response readMultiple(ConfigurationItemIds configurationItemIds) {
        ConfigurationItemDtos result = new ConfigurationItemDtos();
        Collection datas = Collections2.filter((Collection)Lists.transform((List)configurationItemIds.getConfigurationItemIds(), DtoReader.ciIdToCiData), hasReadRight);
        for (ConfigurationItemData data : datas) {
            try {
                ConfigurationItem entity = this.repositoryService.read(data.getId());
                result.add(this.dtoWriter.write(entity));
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", (Object)data);
                logger.error("Exception was: ", (Throwable)re);
            }
        }
        return ResponseFactory.ok((Object)result).build();
    }

    public Response compare(String reference, List<String> ids) {
        ConfigurationItem referenceEntity = this.repositoryService.read(reference);
        ListMultimap multimap = this.comparator.compare(referenceEntity, Lists.transform(ids, (Function)new Function<String, ConfigurationItem>(){

            public ConfigurationItem apply(String input) {
                return QueryResource.this.repositoryService.read(input);
            }
        }));
        return ResponseFactory.ok((Object)Comparison.from((ListMultimap)multimap)).build();
    }

    public Response search(@QueryParam(value="typeName") String typeName, @QueryParam(value="before") Date date) {
        logger.info("Searching for all [{}] with last modified before [{}]", (Object)typeName, (Object)date);
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, 0L, -1L, Lists.newArrayList());
        searchParam.setBefore(date.getCalendar());
        List ids = this.repositoryService.list(searchParam);
        logger.debug("Found ids: {}", (Object)ids);
        return ResponseFactory.ok((Object)new ConfigurationItemIds(Lists.transform((List)ids, DtoReader.ciDataToCiId))).build();
    }
}

