/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.orchestrator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorRegistry.class);
    private static Map<String, Orchestrator> lookup = Maps.newHashMap();

    private static void register(Class<? extends Orchestrator> orchestratorClass) throws IllegalAccessException, InstantiationException {
        if (Modifier.isAbstract(orchestratorClass.getModifiers())) {
            return;
        }
        String name = orchestratorClass.getSimpleName();
        if (orchestratorClass.isAnnotationPresent(Orchestrator.Metadata.class)) {
            Orchestrator.Metadata annotation = orchestratorClass.getAnnotation(Orchestrator.Metadata.class);
            name = annotation.name();
        }
        logger.info("Registering Orchestrator [{}] under name [{}]", orchestratorClass, (Object)name);
        lookup.put(name, orchestratorClass.newInstance());
    }

    public static Orchestrator getOrchestrator(String name) {
        return lookup.get(name);
    }

    public static Set<String> all() {
        return Sets.newHashSet(lookup.keySet());
    }

    static {
        Set orchestratorClasses = ReflectionsHolder.getSubTypesOf(Orchestrator.class);
        for (Class orchestratorClass : orchestratorClasses) {
            try {
                OrchestratorRegistry.register(orchestratorClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't boot the OrchestratorRegistry", e);
            }
        }
    }
}

