/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.RemoteDescriptorRegistry;
import com.xebialabs.deployit.booter.remote.resteasy.InternalServerErrorClientResponseInterceptor;
import com.xebialabs.deployit.engine.xml.LocalDateStringConverter;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooter {
    private static final AtomicBoolean BOOTED = new AtomicBoolean(false);
    private static final AtomicReference<BooterConfig> CONFIG_BOOTED = new AtomicReference();
    private static ResteasyDeployment resteasyDeployment;
    private static final Logger logger;

    public static void boot(BooterConfig config) {
        if (BOOTED.compareAndSet(false, true)) {
            Scannit.boot((Configuration)Configuration.config().scan("com.xebialabs").scan("ext.deployit").with(new AbstractScanner[]{new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()}));
            HttpClientHolder.init(config);
            RemoteBooter.tryAuthenticate(config);
            RemoteBooter.bootResteasy();
            Proxies.init(config);
            RemoteDescriptorRegistry.boot();
            XStreamReaderWriter.registerConfigurationItemAliases();
            CONFIG_BOOTED.compareAndSet(null, config);
        }
    }

    public static void shutdown() {
        if (BOOTED.compareAndSet(true, false)) {
            HttpClientHolder.shutdown();
            resteasyDeployment.stop();
            CONFIG_BOOTED.set(null);
        }
    }

    public static BooterConfig getBootedConfig() {
        return CONFIG_BOOTED.get();
    }

    private static void bootResteasy() {
        resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.getProviderClasses().add(XStreamReaderWriter.class.getName());
        resteasyDeployment.getProviderClasses().add(LocalDateStringConverter.class.getName());
        resteasyDeployment.start();
        resteasyDeployment.getProviderFactory().addClientErrorInterceptor((ClientErrorInterceptor)new InternalServerErrorClientResponseInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryAuthenticate(BooterConfig config) {
        block8: {
            String urlToConnectTo = config.getUrl();
            logger.info("Connecting to the Deployit server at {}...", (Object)urlToConnectTo);
            try {
                HttpClientHolder instance = HttpClientHolder.getInstance();
                HttpResponse execute = instance.getHttpClient().execute((HttpUriRequest)new HttpGet(urlToConnectTo + "/server/info"), instance.getHttpContext());
                try {
                    int responseCode = execute.getStatusLine().getStatusCode();
                    if (responseCode == 200) {
                        logger.info("Successfully connected.");
                        break block8;
                    }
                    if (responseCode == 401 || responseCode == 403) {
                        throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                    }
                    throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
                }
                finally {
                    EntityUtils.consume((HttpEntity)execute.getEntity());
                    instance.getHttpClient().getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(RemoteBooter.class);
    }
}

