/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.resteasy;

import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InternalServerErrorClientResponseInterceptor
implements ClientErrorInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);

    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", (Object)clientResponse.getStatus());
        this.tryDeployitException(clientResponse);
        this.tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            String exceptionType = (String)clientResponse.getHeaders().getFirst((Object)"Exception-Type");
            try {
                String unhandledMessage = (String)clientResponse.getEntity(String.class);
                throw new RuntimeException(String.format("%s: %s", exceptionType, unhandledMessage));
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }

    private void tryDeployitException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Deployit-Exception")) {
            logger.debug("Found Deployit header");
            try {
                String messages = (String)clientResponse.getEntity(String.class);
                if (clientResponse.getHeaders().containsKey((Object)"X-Entity")) {
                    Object o = XStreamReaderWriter.getConfiguredXStream().fromXML(messages);
                    throw new DeployitClientException(o, clientResponse.getStatus());
                }
                throw new DeployitClientException(messages, clientResponse.getStatus());
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }
}

