/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class WorkdirInjectorFactory
extends InjectorFactoryImpl {
    private ResteasyProviderFactory factory;

    public WorkdirInjectorFactory() {
        super(ResteasyProviderFactory.getInstance());
        this.factory = ResteasyProviderFactory.getInstance();
    }

    public WorkdirInjectorFactory(ResteasyProviderFactory factory) {
        super(factory);
        this.factory = factory;
    }

    public MethodInjector createMethodInjector(Class root, Method method) {
        return new WorkdirMethodInjector(root, method, this.factory);
    }

    public static class WorkdirMethodInjector
    extends MethodInjectorImpl {
        private final Method method;

        public WorkdirMethodInjector(Class<?> root, Method method, ResteasyProviderFactory factory) {
            super(root, method, factory);
            this.method = method;
        }

        public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
            try {
                Method realMethod = resource.getClass().getMethod(this.method.getName(), this.method.getParameterTypes());
                if (realMethod.isAnnotationPresent(Workdir.class)) {
                    WorkdirHolder.initWorkdir();
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            return super.invoke(request, httpResponse, resource);
        }
    }
}

