/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFactoryImpl
implements DavLocatorFactory {
    private static final Logger log = LoggerFactory.getLogger(LocatorFactoryImpl.class);
    private final String repositoryPrefix;

    public LocatorFactoryImpl(String repositoryPrefix) {
        this.repositoryPrefix = repositoryPrefix;
    }

    public DavResourceLocator createResourceLocator(String prefix, String href) {
        StringBuffer b = new StringBuffer("");
        if (prefix != null && prefix.length() > 0) {
            b.append(prefix);
            if (href.startsWith(prefix)) {
                href = href.substring(prefix.length());
            }
        }
        if (this.repositoryPrefix != null && this.repositoryPrefix.length() > 0 && !prefix.endsWith(this.repositoryPrefix)) {
            b.append(this.repositoryPrefix);
            if (href.startsWith(this.repositoryPrefix)) {
                href = href.substring(this.repositoryPrefix.length());
            }
        }
        if (href == null || "".equals(href)) {
            href = "/";
        }
        return new Locator(b.toString(), Text.unescape((String)href), this);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String resourcePath) {
        return this.createResourceLocator(prefix, workspacePath, resourcePath, true);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String path, boolean isResourcePath) {
        return new Locator(prefix, path, this);
    }

    private class Locator
    implements DavResourceLocator {
        private final String prefix;
        private final String resourcePath;
        private final DavLocatorFactory factory;
        private final String href;

        private Locator(String prefix, String resourcePath, DavLocatorFactory factory) {
            this.prefix = prefix;
            this.factory = factory;
            if (resourcePath.endsWith("/") && !"/".equals(resourcePath)) {
                resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
            }
            this.resourcePath = resourcePath;
            this.href = prefix + Text.escapePath((String)resourcePath);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getWorkspacePath() {
            return "";
        }

        public String getWorkspaceName() {
            return "";
        }

        public boolean isSameWorkspace(DavResourceLocator locator) {
            return this.isSameWorkspace(locator.getWorkspaceName());
        }

        public boolean isSameWorkspace(String workspaceName) {
            return this.getWorkspaceName().equals(workspaceName);
        }

        public String getHref(boolean isCollection) {
            String suffix = isCollection && !this.isRootLocation() ? "/" : "";
            return this.href + suffix;
        }

        public boolean isRootLocation() {
            return "/".equals(this.resourcePath);
        }

        public DavLocatorFactory getFactory() {
            return this.factory;
        }

        public String getRepositoryPath() {
            return this.getResourcePath();
        }

        public int hashCode() {
            return this.href.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DavResourceLocator) {
                DavResourceLocator other = (DavResourceLocator)obj;
                return this.hashCode() == other.hashCode();
            }
            return false;
        }
    }
}

