/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import java.util.List;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpCygwinConnection
extends SshSftpConnection {
    private Logger logger = LoggerFactory.getLogger(SshSftpCygwinConnection.class);

    public SshSftpCygwinConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a ssh:%s connection to a non-Windows operating system", (Object[])new Object[]{this.sshConnectionType.toString().toLowerCase()});
    }

    @Override
    protected String pathToSftpPath(String path) {
        String translatedPath = this.toCygwinPath(path);
        if (translatedPath == null) {
            throw new RuntimeIOException("Cannot translate path " + path + " to SFTP path because it is not a Windows path or a Cygwin path");
        }
        return translatedPath;
    }

    protected String toCygwinPath(String path) {
        if (path.length() >= 2 && path.charAt(1) == ':') {
            char driveLetter = Character.toLowerCase(path.charAt(0));
            String pathInDrive = path.substring(2).replace('\\', '/');
            String cygwinPath = "/cygdrive/" + driveLetter + pathInDrive;
            this.logger.trace("Translated Windows path [{}] to Cygdrive path [{}]", (Object)path, (Object)cygwinPath);
            return cygwinPath;
        }
        if (path.startsWith("/cygdrive/")) {
            return path;
        }
        return null;
    }

    @Override
    protected CmdLine processCommandLine(CmdLine commandLine) {
        List<CmdLineArgument> args = commandLine.getArguments();
        Preconditions.checkArgument((args.size() > 0 ? 1 : 0) != 0, (Object)"Empty command line");
        String arg0 = args.get(0).toString();
        String arg0CygwinPath = this.toCygwinPath(arg0);
        if (arg0CygwinPath != null) {
            CmdLine modifiedCommandLine = new CmdLine();
            modifiedCommandLine.add(CmdLineArgument.arg(arg0CygwinPath));
            for (int i = 1; i < args.size(); ++i) {
                modifiedCommandLine.add(args.get(i));
            }
            this.logger.debug("Translated first element (command) of command line from Windows path [{}] to Cygwin path [{}]", (Object)arg0, (Object)arg0CygwinPath);
            return super.processCommandLine(modifiedCommandLine);
        }
        return super.processCommandLine(commandLine);
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, OperatingSystemFamily.UNIX, session, commandLine);
    }
}

