/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

@Orchestrator.Metadata(name="group-based", description="Enforce a deployment order based on the deployment group property")
public class GroupBasedOrchestrator
implements Orchestrator {
    public Orchestration orchestrate(DeltaSpecification specification) {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(Multimaps.index((Iterable)specification.getDeltas(), (Function)new Function<Delta, Integer>(){

            public Integer apply(Delta input) {
                Container container = GroupBasedOrchestrator.getDeployed(input).getContainer();
                Integer deploymentGroup = Integer.MIN_VALUE;
                if (container.hasProperty("deploymentGroup")) {
                    deploymentGroup = (Integer)container.getProperty("deploymentGroup");
                }
                if (deploymentGroup == null) {
                    deploymentGroup = Integer.MIN_VALUE;
                }
                return deploymentGroup;
            }
        }).asMap());
        Collection interleavedPlan = Collections2.transform(treeMap.values(), (Function)new Function<Collection<Delta>, Orchestration>(){

            public Orchestration apply(Collection<Delta> input) {
                return Orchestrations.interleaved((List)Lists.newArrayList(input));
            }
        });
        return Orchestrations.serial((List)Lists.newArrayList((Iterable)interleavedPlan));
    }

    private static Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}

