/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger.contrib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.trigger.Action;
import com.xebialabs.deployit.plugin.trigger.StepTrigger;
import com.xebialabs.deployit.plugin.trigger.TaskTrigger;
import com.xebialabs.deployit.plugin.trigger.Trigger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TriggerExecutionListener
implements ExecutionStateListener {
    private List<Trigger> allTriggers;
    private final Deltas deltas;
    private final DeployedApplication deployedApplication;

    public TriggerExecutionListener(List<Trigger> triggers, Deltas deltas, DeployedApplication deployedApplication) {
        this.allTriggers = triggers;
        this.deltas = deltas;
        this.deployedApplication = deployedApplication;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        Iterable stepTriggers = Iterables.filter(this.allTriggers, new FireTriggerPredicate<StepExecutionState>(StepTrigger.class, event.previousState(), event.currentState()));
        HashMap commonCtx = Maps.newHashMap();
        commonCtx.put("task", event.task());
        commonCtx.put("step", event.step());
        this.executeTriggers(stepTriggers, commonCtx);
    }

    protected void executeTriggers(Iterable<Trigger> triggers, Map<String, Object> commonCtx) {
        commonCtx.put("deltas", this.deltas);
        commonCtx.put("deployedApplication", this.deployedApplication);
        Iterable actions = Iterables.concat((Iterable)Iterables.transform(triggers, (Function)new Function<Trigger, Iterable<Action>>(){

            public Iterable<Action> apply(Trigger input) {
                return input.getActions();
            }
        }));
        for (Action action : actions) {
            HashMap ctx = Maps.newHashMap(commonCtx);
            ctx.put("action", action);
            action.execute(ctx);
        }
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        Iterable taskTriggers = Iterables.filter(this.allTriggers, new FireTriggerPredicate<TaskExecutionState>(TaskTrigger.class, event.previousState(), event.currentState()));
        HashMap commonCtx = Maps.newHashMap();
        commonCtx.put("task", event.task());
        this.executeTriggers(taskTriggers, commonCtx);
    }

    static class FireTriggerPredicate<T>
    implements Predicate<Trigger> {
        private Class<?> triggerType;
        private T fromState;
        private T toState;

        public FireTriggerPredicate(Class<?> triggerType, T fromState, T toState) {
            this.triggerType = triggerType;
            this.fromState = fromState;
            this.toState = toState;
        }

        public boolean apply(Trigger input) {
            return this.triggerType.isInstance((Object)input) && input.getFromState().equivalentTo(this.fromState) && input.getToState().equivalentTo(this.toState);
        }
    }
}

