/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.verification;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Verify(clazz=Verification.class, type="satisfiesProperties")
public @interface SatisfiesPropertyVerification {

    public static class Verification
    implements TypeVerification {
        public void verify(Descriptor descriptor, VerificationContext context) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                PropertyDescriptor rolesProp;
                String propName = propertyDescriptor.getName();
                if (propName.startsWith("satisfies") && !this.isSatisfiesKind(propertyDescriptor)) {
                    context.error("Property [%s] satisfies a release condition but is not of type boolean or string.", new Object[]{propName});
                }
                if (!propName.startsWith("satisfies") || (rolesProp = descriptor.getPropertyDescriptor("roles" + propName.substring("satisfies".length()))) == null || rolesProp.getKind() == PropertyKind.SET_OF_STRING) continue;
                context.error("Property [%s] defines the allowed roles for a release condition but is not of type list of string", new Object[]{rolesProp.getName()});
            }
        }

        private boolean isSatisfiesKind(PropertyDescriptor propertyDescriptor) {
            return EnumSet.of(PropertyKind.BOOLEAN, PropertyKind.STRING).contains(propertyDescriptor.getKind());
        }
    }
}

