/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.w3c.dom.Element;

class VerificationConverter {
    public static final String VERIFICATION_ELEMENT_NAME = "verification";
    private static final Map<String, Class<? extends TypeVerification>> verificationTypeMap = Maps.newHashMap();

    VerificationConverter() {
    }

    static boolean isVerification(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Verify.class);
    }

    static TypeVerification makeVerification(Annotation verificationAnnotation) {
        Class<? extends Annotation> verificationClazz = verificationAnnotation.annotationType();
        Verify verify = verificationClazz.getAnnotation(Verify.class);
        return VerificationConverter.instantiate(verify.clazz());
    }

    static TypeVerification makeVerification(Element element, Type ciType) {
        String type = element.getAttribute("type");
        TypeVerification rule = VerificationConverter.createRule(type);
        if (rule != null) {
            return rule;
        }
        throw new IllegalArgumentException(String.format("Could not find verification type %s defined on type %s", type, ciType));
    }

    private static TypeVerification createRule(String type) {
        if (verificationTypeMap.containsKey(type)) {
            return VerificationConverter.instantiate(verificationTypeMap.get(type));
        }
        return null;
    }

    private static TypeVerification instantiate(Class<? extends TypeVerification> rule) {
        try {
            return rule.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        }
    }

    static {
        Set rules = Scannit.getInstance().getTypesAnnotatedWith(Verify.class);
        for (Class validationRuleAnnotation : rules) {
            Verify verify = validationRuleAnnotation.getAnnotation(Verify.class);
            verificationTypeMap.put(verify.type(), verify.clazz());
        }
    }
}

