/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.repository.WorkDir;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkdirCleanerTrigger
implements ExecutionStateListener {
    private List<WorkDir> workDirs = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(WorkdirCleanerTrigger.class);

    public WorkdirCleanerTrigger(WorkDir ... workDir) {
        for (WorkDir dir : workDir) {
            this.workDirs.add(dir);
        }
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState().isFinal()) {
            logger.info("Cleaning Workdirs for task [{}]", (Object)event.task().getId());
            this.cleanWorkdirs();
        }
    }

    private void cleanWorkdirs() {
        for (WorkDir workDir : this.workDirs) {
            try {
                workDir.delete();
            }
            catch (RuntimeException re) {
                logger.error("Failed to clean WorkDir [{}]", (Object)workDir);
            }
        }
    }

    public List<WorkDir> getWorkDirs() {
        return this.workDirs;
    }
}

