/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.xml.AbstractConfigurationItemConverter;
import com.xebialabs.deployit.engine.xml.XStreamProvider;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class ConfigurationItemConverter
extends AbstractConfigurationItemConverter {
    protected void writeCiProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        writer.addAttribute("ref", (String)value);
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        for (String s : (Collection)value) {
            writer.startNode("ci");
            writer.addAttribute("ref", s);
            writer.endNode();
        }
    }

    protected ConfigurationItem readProperties(HierarchicalStreamReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        ConfigurationItem toBeReturned = configurationItem;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("validation-messages")) {
                toBeReturned = new ValidatedConfigurationItem(configurationItem);
                ArrayList messages = Lists.newArrayList();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    messages.add(new ValidationMessage(reader.getAttribute("ci"), reader.getAttribute("property"), reader.getValue()));
                    reader.moveUp();
                }
                ((ValidatedConfigurationItem)toBeReturned).setValidations((List)messages);
            } else {
                this.readProperty(reader, descriptor, configurationItem);
            }
            reader.moveUp();
        }
        return toBeReturned;
    }

    protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        propertyDescriptor.set(configurationItem, (Object)reader.getAttribute("ref"));
    }

    protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        ArrayList c = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            c.add(reader.getAttribute("ref"));
            reader.moveUp();
        }
        propertyDescriptor.set(configurationItem, (Object)c);
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        ArrayList strings = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            strings.add(reader.getValue());
            reader.moveUp();
        }
        propertyDescriptor.set(configurationItem, (Object)strings);
    }
}

