/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.legacy;

import com.xebialabs.deployit.engine.api.execution.TaskState;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TaskInfo {
    private final TaskState task;

    public TaskInfo(TaskState task) {
        this.task = task;
    }

    public static List<TaskInfo> asList(List<TaskState> tasks) {
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>(tasks.size());
        for (TaskState task : tasks) {
            result.add(new TaskInfo(task));
        }
        return result;
    }

    public TaskState getTaskState() {
        return this.task;
    }

    public String getId() {
        return this.task.getId();
    }

    public String getLabel() {
        return this.task.getDescription();
    }

    public String getState() {
        return this.task.getState().toString();
    }

    public Calendar getStartDate() {
        return this.task.getStartDate().toGregorianCalendar();
    }

    public Calendar getCompletionDate() {
        return this.task.getCompletionDate().toGregorianCalendar();
    }

    public int getNrOfSteps() {
        return this.task.getNrSteps();
    }

    public int getCurrentStepNr() {
        return this.task.getCurrentStepNr();
    }

    public String getUser() {
        throw new IllegalStateException("Can't get the user from the task.");
    }

    public String getApplication() {
        return (String)this.task.getMetadata().get("application");
    }

    public String getVersion() {
        return (String)this.task.getMetadata().get("version");
    }

    public String getEnvironment() {
        return (String)this.task.getMetadata().get("environment");
    }

    public int getFailureCount() {
        return this.task.getFailureCount();
    }

    public String toString() {
        return String.format("Task %s (%s)", this.task.getId(), this.task.getState());
    }
}

