/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import java.util.Map;
import java.util.regex.Pattern;

@Metadata(virtual=true, description="Default implementation of a CI that provides ID, name and type information.")
public class BaseConfigurationItem
implements ConfigurationItem,
Comparable<BaseConfigurationItem> {
    protected String id = String.valueOf(System.identityHashCode(this));
    protected Type type = Type.valueOf(this.getClass());
    protected Map<String, Object> syntheticProperties = Maps.newHashMap();
    private String $token;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        int indexOfLastSlash = this.id.lastIndexOf(47);
        if (indexOfLastSlash > -1) {
            return this.id.substring(indexOfLastSlash + 1);
        }
        return this.id;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem that = (BaseConfigurationItem)thatObject;
        return this.getId().equals(that.getId());
    }

    @Override
    public int compareTo(BaseConfigurationItem o) {
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        if (this.id == null) {
            return this.getClass().getName() + "[id = null]";
        }
        if (Pattern.matches("[ '\"]", this.id)) {
            return "\"" + this.id + "\"";
        }
        return this.id;
    }

    @Override
    @Deprecated
    public Map<String, Object> getSyntheticProperties() {
        return this.syntheticProperties;
    }

    @Override
    @Deprecated
    public <T> T getSyntheticProperty(String key) {
        return (T)this.syntheticProperties.get(key);
    }

    @Deprecated
    public boolean hasSyntheticProperty(String key) {
        return this.syntheticProperties.containsKey(key);
    }

    @Override
    @Deprecated
    public <T> void putSyntheticProperty(String key, T value) {
        this.syntheticProperties.put(key, value);
    }

    @Deprecated
    public void putSyntheticProperties(Map<String, String> properties) {
        this.syntheticProperties.putAll(properties);
    }

    @Deprecated
    public void setSyntheticProperties(Map<String, Object> additionalProperties) {
        this.syntheticProperties = additionalProperties;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.getPropertyDescriptor(key).get(this);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.type.getDescriptor().getPropertyDescriptor(key) != null;
    }

    @Override
    public <T> void setProperty(String key, T value) {
        this.getPropertyDescriptor(key).set(this, value);
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.type.getDescriptor().getPropertyDescriptor(name);
        Preconditions.checkArgument((pd != null ? 1 : 0) != 0, (String)"Type %s has no property %s", (Object[])new Object[]{this.type, name});
        return pd;
    }

    public String get$token() {
        return this.$token;
    }

    public void set$token(String $token) {
        this.$token = $token;
    }
}

