/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        IndexToLocationTable loc = ttf.getIndexToLocation();
        long[] offsets = loc.getOffsets();
        int numGlyphs = maxp.getNumGlyphs();
        this.glyphs = new GlyphData[numGlyphs];
        for (int i = 0; i < numGlyphs - 1; ++i) {
            GlyphData glyph = new GlyphData();
            data.seek(this.getOffset() + offsets[i]);
            glyph.initData(ttf, data);
            this.glyphs[i] = glyph;
        }
    }

    public GlyphData[] getGlyphs() {
        return this.glyphs;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }
}

