/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tika.fork.ForkSerializer;
import org.apache.tika.fork.ForkServer;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForkClient {
    private final ClassLoader loader;
    private final File directory;
    private final Process process;
    private final DataOutputStream output;
    private final DataInputStream input;
    private final InputStream error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForkClient(ClassLoader loader) throws IOException {
        this.loader = loader;
        this.directory = File.createTempFile("apache-tika-", "-oop");
        this.directory.delete();
        this.directory.mkdir();
        boolean ok = false;
        try {
            this.copyClassToDirectory(ForkServer.class);
            this.copyClassToDirectory(ForkSerializer.class);
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(this.directory);
            builder.command("java", ForkServer.class.getName());
            this.process = builder.start();
            this.output = new DataOutputStream(this.process.getOutputStream());
            this.input = new DataInputStream(this.process.getInputStream());
            this.error = this.process.getErrorStream();
            ok = true;
        }
        finally {
            if (!ok) {
                this.delete(this.directory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyClassToDirectory(Class<?> klass) throws FileNotFoundException, IOException {
        String path = klass.getName().replace('.', '/') + ".class";
        InputStream input = this.loader.getResourceAsStream(path);
        try {
            File file = new File(this.directory, path);
            file.getParentFile().mkdirs();
            FileOutputStream output = new FileOutputStream(file);
            try {
                IOUtils.copy(input, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        finally {
            input.close();
        }
    }

    public synchronized Object echo(Object message) throws IOException {
        this.consumeErrors();
        this.output.write(1);
        ForkSerializer.serialize(this.output, message);
        this.output.flush();
        this.readResponseType();
        try {
            return ForkSerializer.deserialize(this.input, this.loader).toString();
        }
        catch (ClassNotFoundException e) {
            throw new IOExceptionWithCause("Unable to read echo response", e);
        }
    }

    public synchronized void close() {
        try {
            this.output.close();
            this.input.close();
            this.error.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.process.destroy();
        this.delete(this.directory);
    }

    private byte readResponseType() throws IOException {
        int type;
        while (true) {
            this.consumeErrors();
            type = this.input.read();
            if (type == -1) {
                throw new IOException("Unexpected end of stream encountered");
            }
            if (type == 2) {
                this.findResource(this.input.readUTF());
                continue;
            }
            if (type != 3) break;
            this.findResources(this.input.readUTF());
        }
        return (byte)type;
    }

    private void findResource(String name) throws IOException {
        InputStream stream = this.loader.getResourceAsStream(name);
        if (stream != null) {
            this.output.writeBoolean(true);
            this.writeAndCloseStream(stream);
        } else {
            this.output.writeBoolean(false);
        }
        this.output.flush();
    }

    private void findResources(String name) throws IOException {
        Enumeration<URL> resources = this.loader.getResources(name);
        while (resources.hasMoreElements()) {
            this.output.writeBoolean(true);
            this.writeAndCloseStream(resources.nextElement().openStream());
        }
        this.output.writeBoolean(false);
        this.output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndCloseStream(InputStream stream) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[65535];
            while ((n = stream.read(buffer)) != -1) {
                this.output.writeShort(n);
                this.output.write(buffer, 0, n);
            }
            this.output.writeShort(0);
        }
        finally {
            stream.close();
        }
    }

    private void consumeErrors() throws IOException {
        int n;
        while ((n = this.error.available()) > 0) {
            byte[] b = new byte[n];
            if ((n = this.error.read(b)) <= 0) continue;
            System.err.write(b, 0, n);
        }
    }

    private void delete(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                this.delete(child);
            }
        }
        file.delete();
    }
}

