/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class ZipInputShop
extends RawZipFile<ZipArchiveEntry>
implements InputShop<ZipArchiveEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    private boolean appendee;
    private ZipCryptoParameters param;

    public ZipInputShop(ZipDriver driver, FsModel model, ReadOnlyFile rof) throws IOException {
        super(rof, driver);
        this.driver = driver;
        this.model = model;
    }

    public FsModel getModel() {
        return this.model;
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param = this.param;
        if (null == param) {
            this.param = param = this.driver.zipCryptoParameters(this);
        }
        return param;
    }

    protected boolean isAppendee() {
        return this.appendee;
    }

    final void setAppendee(boolean appendee) {
        this.appendee = appendee;
    }

    public int getSize() {
        return super.size();
    }

    public InputSocket<ZipArchiveEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<ZipArchiveEntry> {
            Input() {
            }

            public ZipArchiveEntry getLocalTarget() throws IOException {
                ZipArchiveEntry entry = (ZipArchiveEntry)ZipInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                return entry;
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new UnsupportedOperationException();
            }

            public InputStream newInputStream() throws IOException {
                ZipArchiveEntry lt = this.getLocalTarget();
                Entry pt = this.getPeerTarget();
                ZipArchiveEntry zpt = pt instanceof ZipArchiveEntry ? (ZipArchiveEntry)pt : null;
                ZipDriver driver = ZipInputShop.this.driver;
                return ZipInputShop.this.getInputStream(lt.getName(), driver.check(ZipInputShop.this, lt), null == zpt || driver.process(ZipInputShop.this, lt, zpt));
            }
        }
        return new Input();
    }
}

