/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.util.OverthereFileCopier;

public abstract class BaseOverthereFile<C extends BaseOverthereConnection>
implements OverthereFile {
    protected C connection;

    protected BaseOverthereFile() {
        this.connection = null;
    }

    protected BaseOverthereFile(C connection) {
        this.connection = connection;
    }

    public C getConnection() {
        return this.connection;
    }

    @Override
    public OverthereFile getFile(String child) {
        return this.getConnection().getFile(this, child);
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        if (this.isDirectory()) {
            for (OverthereFile each : this.listFiles()) {
                each.deleteRecursively();
            }
        }
        this.delete();
    }

    @Override
    public final void copyTo(OverthereFile dest) {
        Preconditions.checkArgument((boolean)(dest instanceof BaseOverthereFile), (Object)"dest is not a subclass of BaseOverthereFile");
        ((BaseOverthereFile)dest).copyFrom(this);
    }

    protected void copyFrom(OverthereFile source) {
        OverthereFileCopier.copy(source, this);
    }

    public abstract String toString();
}

