/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.api.internal.ImportHelper;
import com.xebialabs.deployit.cli.api.internal.PrintHelper;
import com.xebialabs.deployit.cli.api.legacy.TaskInfo;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.InternalComparisonProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@CliObject(name="deployit")
@ClassHelp(description="The main gateway to interfacing with Deployit.")
public class DeployitClient
extends DocumentedObject {
    private final InternalComparisonProxy comparisonService;
    private final ControlService controlService;
    private final InspectionService inspectionService;
    private final PackageService packageService;
    private final RepositoryService repositoryService;
    private final ServerService serverService;
    private final TaskService taskService;
    private final DeployitCommunicator communicator;

    public DeployitClient() {
        this.comparisonService = null;
        this.controlService = null;
        this.inspectionService = null;
        this.packageService = null;
        this.repositoryService = null;
        this.serverService = null;
        this.taskService = null;
        this.communicator = null;
    }

    public DeployitClient(ProxiesInstance proxies) {
        this.communicator = proxies.getCommunicator();
        this.comparisonService = proxies.getComparison();
        this.controlService = proxies.getControlTask();
        this.inspectionService = proxies.getDiscovery();
        this.packageService = proxies.getImportablePackage();
        this.repositoryService = proxies.getRepository();
        this.taskService = proxies.getTaskRegistry();
        this.serverService = proxies.getServer();
    }

    @MethodHelp(description="Import a package located on the server or local file system.", parameters={@ParameterHelp(name="importablePackage", description="This is either:\n\t- The name of the importable package on the server\n\t- The absolute path to a local importable package.")})
    public ConfigurationItem importPackage(String importablePackageName) {
        return new ImportHelper(this.communicator).doImport("/deployit", importablePackageName);
    }

    @MethodHelp(description="List all importable packages on the server.")
    public List<String> listImportablePackages() {
        return this.packageService.list();
    }

    @MethodHelp(description="Gracefully stop an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void stopTask(String taskId) {
        this.taskService.stop(taskId);
    }

    @MethodHelp(description="Start a deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTask(String taskId) {
        this.taskService.start(taskId);
    }

    @MethodHelp(description="Start a deployment task and wait for it to finish", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        TaskState ti = null;
        while (!done) {
            ti = this.taskService.getTask(taskId);
            TaskExecutionState st = ti.getState();
            if (st == TaskExecutionState.EXECUTED || st == TaskExecutionState.STOPPED) {
                done = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (ti.getState() == TaskExecutionState.EXECUTED) {
            this.taskService.archive(taskId);
        }
    }

    @MethodHelp(description="Abort an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void abortTask(String taskId) {
        this.taskService.abort(taskId);
    }

    @MethodHelp(description="Cancel a stopped deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void cancelTask(String taskId) {
        this.taskService.cancel(taskId);
    }

    public void skipSteps(String taskId, List<Integer> stepIds) {
        if (stepIds == null || stepIds.size() == 0) {
            return;
        }
        TaskWithSteps steps = this.taskService.getSteps(taskId);
        ArrayList<Integer> skip = new ArrayList<Integer>();
        ArrayList<Integer> unskip = new ArrayList<Integer>();
        for (Integer stepId : stepIds) {
            StepExecutionState state = ((StepState)steps.getSteps().get(stepId - 1)).getState();
            if (state == StepExecutionState.PENDING || state == StepExecutionState.FAILED) {
                skip.add(stepId);
                continue;
            }
            if (state != StepExecutionState.SKIP) continue;
            unskip.add(stepId);
        }
        if (!skip.isEmpty()) {
            this.taskService.skip(taskId, skip);
        }
        if (!unskip.isEmpty()) {
            this.taskService.unskip(taskId, unskip);
        }
    }

    @MethodHelp(description="(Un)skip steps of the task.\n- If a step is in the PENDING or FAILED state, it will be SKIPPED.\n- If a step is in the SKIPPED state it will be PENDING. ", parameters={@ParameterHelp(name="taskId", description="The id of the task"), @ParameterHelp(name="stepIds", description="The ids of the steps to skip or unskip")})
    public void skipSteps(String taskId, Integer[] stepIds) {
        if (stepIds == null) {
            return;
        }
        this.skipSteps(taskId, Lists.newArrayList((Object[])stepIds));
    }

    @MethodHelp(description="Assign a pending task to another principal", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="owner", description="The new task owner.")})
    public void assignTask(String taskId, String owner) {
        this.taskService.assign(taskId, owner);
    }

    @MethodHelp(description="Creates a task to discover middleware starting with given CI. Refer to plugin configuration item documentation to see which fields are required for discover.", parameters={@ParameterHelp(name="ci", description="The configuration item with all required discovery fields filled in.")})
    public String createDiscoveryTask(ConfigurationItem ci) {
        return this.inspectionService.createTask(this.inspectionService.prepare(ci));
    }

    @MethodHelp(description="Returns results for the already executed discovery task.", parameters={@ParameterHelp(name="taskId", description="Id of the executed discovery task.")})
    public List<ConfigurationItem> retrieveDiscoveryResults(String taskId) {
        return this.inspectionService.retrieveInspectionResults(taskId);
    }

    @MethodHelp(description="Execute the control task on the provided configuration item. If the control tasks executes successfully, no output is shown. In the case of an error, log output is shown.", parameters={@ParameterHelp(name="taskName", description="The control task name eg. \"start\""), @ParameterHelp(name="ci", description="The configuration item to execute the control task on")})
    public void executeControlTask(String taskName, ConfigurationItem ci) {
        Control control = this.controlService.prepare(taskName, ci.getId());
        String task = this.controlService.createTask(control);
        this.startTaskAndWait(task);
    }

    @MethodHelp(description="Describe the CI class, with all the values it takes.", parameters={@ParameterHelp(name="shortName", description="The (Short) name of the CI eg. \"Host\", \"WasDataSource\", etc")})
    public void describe(String typeName) {
        DescriptorHelper.describe(typeName);
    }

    @MethodHelp(description="Print a tree-view of a CI", parameters={@ParameterHelp(name="ci", description="The CI to print")})
    public void print(ConfigurationItem ci) {
        PrintHelper.getInstance().printCi(ci, this.repositoryService);
    }

    public void print(Collection<ConfigurationItem> cis) {
        PrintHelper.getInstance().printCis(cis, this.repositoryService);
    }

    public Comparison compare(String reference, List<String> ids) {
        return this.comparisonService.compare(reference, ids);
    }

    @MethodHelp(description="Retrieve Deployit server information")
    public ServerInfo info() {
        return this.serverService.getInfo();
    }

    @MethodHelp(description="Run the Deployit server garbage collector")
    public void runGarbageCollector() {
        this.serverService.gc();
    }

    @MethodHelp(description="Shutdown the Deployit server")
    public void shutdown() {
        this.serverService.shutdown();
    }

    @MethodHelp(description="Retrieve the task information for a (running) deployment task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")}, returns="The metadata associated with the task")
    public TaskInfo retrieveTaskInfo(String taskId) {
        return new TaskInfo(this.taskService.getTask(taskId));
    }

    @MethodHelp(description="List unfinished tasks for the current user.")
    public List<TaskInfo> listUnfinishedTasks() {
        return TaskInfo.asList(this.taskService.getMyCurrentTasks());
    }

    @MethodHelp(description="List all unfinished tasks registered in the server. Requires administrative permission.")
    public List<TaskInfo> listAllUnfinishedTasks() {
        return TaskInfo.asList(this.taskService.getAllCurrentTasks());
    }

    @MethodHelp(description="!Deprecated! Discover middleware associated with the specified discoverable configuration item. Refer to plugin configuration item documentation to see which fields are required for discover.", parameters={@ParameterHelp(name="ci", description="The configuration item with all required discovery fields filled in")}, returns="RepositoryObjects containing all discovered middleware associated with the specified discoverable ci")
    public List<ConfigurationItem> discover(ConfigurationItem ci) {
        String task = this.createDiscoveryTask(ci);
        this.startTaskAndWait(task);
        if (!this.retrieveTaskInfo(task).getTaskState().getState().equals((Object)TaskExecutionState.EXECUTED)) {
            this.taskService.cancel(task);
            throw new IllegalStateException("Inspection task can not be finished.");
        }
        return this.retrieveDiscoveryResults(task);
    }
}

