/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.SearchParameters;

public class SearchParameterFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

    public static SearchParameters createSearchParam(Type type, long page, long resultPerPage) {
        SearchParameters searchParam = new SearchParameters();
        if (type != null) {
            searchParam.setType(type);
        }
        searchParam.setPage(page);
        if (resultPerPage > 0L) {
            searchParam.setResultsPerPage(resultPerPage);
        } else if (resultPerPage == 0L) {
            searchParam.setResultsPerPage(25L);
        }
        return searchParam;
    }

    public static SearchParameters createSearchParam(Type typeName, long page, long resultPerPage, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, page, resultPerPage);
        if (SearchParameterFactory.isNotBlank(parent)) {
            searchParam.setParent(parent);
        }
        if (SearchParameterFactory.isNotBlank(id)) {
            searchParam.setName(id);
        }
        return searchParam;
    }

    private static boolean isNotBlank(String parent) {
        return !Strings.nullToEmpty((String)parent).trim().isEmpty();
    }
}

