/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.reader.ManifestEntry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DeployitJarManifest {
    private static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    private static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.3";
    private static final String APPLICATION_ATTRIBUTE_NAME = "CI-Application";
    private static final String VERSION_ATTRIBUTE_NAME = "CI-Version";
    private final Manifest manifest;

    private DeployitJarManifest(Manifest manifest) {
        this.manifest = manifest;
        this.verifyPackageFormatVersion();
    }

    public static DeployitJarManifest readFromFile(TFile manifestFile) {
        Manifest manifest;
        TFileInputStream in = null;
        try {
            in = new TFileInputStream((File)manifestFile);
            manifest = new Manifest((InputStream)in);
        }
        catch (IOException exception) {
            try {
                throw new RuntimeIOException("Cannot read manifest file " + manifestFile, exception);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return new DeployitJarManifest(manifest);
    }

    public String getApplicationName() {
        return this.getMainEntryAttribute(APPLICATION_ATTRIBUTE_NAME);
    }

    public String getApplicationVersion() {
        return this.getMainEntryAttribute(VERSION_ATTRIBUTE_NAME);
    }

    private String getMainEntryAttribute(String attributeName) {
        String attributeValue = this.manifest.getMainAttributes().getValue(attributeName);
        if (attributeValue == null || attributeValue.trim().isEmpty()) {
            throw new ImporterException("Deployment package does not declare the " + attributeName + " main attribute", new Object[0]);
        }
        return attributeValue;
    }

    private void verifyPackageFormatVersion() {
        String packageFormatVersion = this.getMainEntryAttribute(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME);
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(packageFormatVersion)) {
            throw new ImporterException("Deployment package does not have the right Deployit-Package-Format-Version header value (actual: " + packageFormatVersion + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")", new Object[0]);
        }
    }

    public Collection<ManifestEntry> getEntries() {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        for (Map.Entry<String, Attributes> entry : this.manifest.getEntries().entrySet()) {
            entries.add(new ManifestEntry(entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    public ManifestEntry getEntry(String key) {
        Map<String, Attributes> entries = this.manifest.getEntries();
        if (entries.containsKey(key)) {
            return new ManifestEntry(key, this.manifest.getAttributes(key));
        }
        return null;
    }
}

