/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.resteasy;

import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InternalServerErrorClientResponseInterceptor
implements ClientErrorInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);

    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", (Object)clientResponse.getStatus());
        this.tryDeployitException(clientResponse);
        this.tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            String exceptionType = (String)clientResponse.getHeaders().getFirst((Object)"X-Exception-Type");
            String path = (String)clientResponse.getHeaders().getFirst((Object)"X-Path");
            try {
                String messages = this.tryToReadEntity(clientResponse);
                throw new RuntimeException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""));
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }

    private void tryDeployitException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Deployit-Exception")) {
            logger.debug("Found Deployit header");
            try {
                String exceptionType = (String)clientResponse.getHeaders().getFirst((Object)"X-Exception-Type");
                String path = (String)clientResponse.getHeaders().getFirst((Object)"X-Path");
                String messages = this.tryToReadEntity(clientResponse);
                if (clientResponse.getHeaders().containsKey((Object)"X-Entity") && messages != null) {
                    Object o = XStreamReaderWriter.getConfiguredXStream().fromXML(messages);
                    throw new DeployitClientException(o, clientResponse.getStatus());
                }
                throw new DeployitClientException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""), clientResponse.getStatus());
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }

    private String tryToReadEntity(ClientResponse<?> clientResponse) {
        String messages = null;
        try {
            messages = (String)clientResponse.getEntity(String.class);
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        return messages;
    }
}

