/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javassist.util.proxy.ProxyObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskRecoveryTrigger
implements ExecutionStateListener {
    private File recoveryDir;
    private static final Logger logger = LoggerFactory.getLogger(TaskRecoveryTrigger.class);

    public TaskRecoveryTrigger(File recoveryDir) {
        this.recoveryDir = recoveryDir;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        TaskState task = event.task();
        this.writeRecovery(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecovery(TaskState task) {
        String id = task.getId();
        ProxyObjectOutputStream os = null;
        try {
            os = new ProxyObjectOutputStream((OutputStream)new FileOutputStream(this.getFile(id)));
            os.writeObject(task);
        }
        catch (IOException e) {
            try {
                logger.error(String.format("Could not write recovery file for [%s]", id), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(os);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)os);
        }
        Closeables.closeQuietly((Closeable)os);
    }

    private File getFile(String id) {
        return new File(this.recoveryDir, id + ".task");
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState().isFinal()) {
            File file = this.getFile(event.task().getId());
            file.delete();
        } else {
            this.writeRecovery((TaskState)event.task());
        }
    }
}

