/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.container;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LifeCycleContributor {
    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext plan) {
        Set<Container> containers = LifeCycleContributor.gatherTargets(deltas.getDeltas());
        for (Container container : containers) {
            if (!Strings.nullToEmpty((String)container.getRestartScript()).trim().isEmpty()) {
                LifeCycleContributor.addRestartSteps(plan, container);
                continue;
            }
            LifeCycleContributor.addStartAndStopSteps(plan, container);
        }
    }

    private static void addStartAndStopSteps(DeploymentPlanningContext plan, Container target) {
        Preconditions.checkArgument((!Strings.nullToEmpty((String)target.getStartScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"start script must be specified when no restart script defined.");
        Preconditions.checkArgument((!Strings.nullToEmpty((String)target.getStopScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"stop script must be specified when no restart script defined.");
        plan.addStep(LifeCycleContributor.createScriptStep("Start", target, target.getStartScript(), target.getStartOrder()));
        LifeCycleContributor.addWaitStep(plan, "start", target, target.getStartWaitTime(), target.getStartOrder());
        plan.addStep(LifeCycleContributor.createScriptStep("Stop", target, target.getStopScript(), target.getStopOrder()));
        LifeCycleContributor.addWaitStep(plan, "stop", target, target.getStopWaitTime(), target.getStopOrder());
    }

    private static void addRestartSteps(DeploymentPlanningContext plan, Container target) {
        Step step = LifeCycleContributor.createScriptStep("Restart", target, target.getRestartScript(), target.getRestartOrder());
        plan.addStep(step);
        LifeCycleContributor.addWaitStep(plan, "restart", target, target.getRestartWaitTime(), target.getRestartOrder());
    }

    private static void addWaitStep(DeploymentPlanningContext plan, String action, Container target, int waitTime, int scriptOrder) {
        if (waitTime > 0) {
            plan.addStep((Step)new WaitStep(scriptOrder + 1, waitTime, target.getName(), action));
        }
    }

    private static Step createScriptStep(String verb, Container container, String script, int scriptOrder) {
        HashMap vars = Maps.newHashMap();
        vars.put("container", container);
        return new ScriptExecutionStep(scriptOrder, script, container, vars, LifeCycleContributor.getDescription(verb, container));
    }

    private static String getDescription(String verb, Container container) {
        return String.format("%s %s", verb, container.getName());
    }

    private static Set<Container> gatherTargets(List<Delta> operations) {
        TreeSet targets = Sets.newTreeSet();
        for (Delta operation : operations) {
            LifeCycleContributor.addTarget(targets, operation.getOperation(), operation.getDeployed());
            LifeCycleContributor.addTarget(targets, operation.getOperation(), operation.getPrevious());
        }
        return targets;
    }

    private static void addTarget(Set<Container> targets, Operation operation, Deployed<?, ?> deployed) {
        AbstractDeployed abstractDeployed;
        boolean restartRequired;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof AbstractDeployed && (restartRequired = (abstractDeployed = (AbstractDeployed)deployed).isRestartRequired())) {
            if (operation != Operation.NOOP) {
                targets.add(LifeCycleContributor.getRootContainer((HostContainer)deployed.getContainer()));
            } else if (abstractDeployed.isRestartRequiredForNoop()) {
                targets.add(LifeCycleContributor.getRootContainer((HostContainer)deployed.getContainer()));
            }
        }
    }

    private static Container getRootContainer(HostContainer hostContainer) {
        if (hostContainer instanceof Container) {
            return (Container)hostContainer;
        }
        if (hostContainer instanceof NestedContainer) {
            return ((NestedContainer)hostContainer).getRootContainer();
        }
        throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
    }
}

