/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PowerShellStep
implements Step {
    private static final String STANDARD_RUNTIME_PATH = "powershell/runtime";
    private HostContainer container;
    private String scriptPath;
    private Map<String, Object> powerShellVars;
    private String description;
    private boolean uploadArtifactData = true;
    private static Logger logger = LoggerFactory.getLogger(PowerShellStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.powershell.scripts");

    public PowerShellStep(HostContainer container, String scriptPath, Map<String, Object> powerShellVars, String description) {
        this.container = (HostContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        Preconditions.checkArgument((this.container.getHost().getOs() == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (Object)"PowerShell scripts can only be run on Windows hosts");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.powerShellVars = (Map)Preconditions.checkNotNull(powerShellVars, (Object)"powerShellVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExitCode doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            OverthereConnection conn;
            block8: {
                StepExitCode stepExitCode;
                conn = this.container.getHost().getConnection();
                try {
                    String finalScript = this.aggregateScript(conn);
                    ScriptUtils.dumpScript((String)OverthereUtils.getName((String)this.scriptPath), (String)finalScript, (Logger)scriptsLogger);
                    OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)this.scriptPath, (String)finalScript);
                    int res = this.executePowerShellScript(ctx, conn, uploadedScriptFile);
                    logger.debug("Exit code: {}", (Object)res);
                    if (res != 0) break block8;
                    stepExitCode = StepExitCode.SUCCESS;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly((Closeable)conn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)conn);
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.FAIL;
            Closeables.closeQuietly((Closeable)conn);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection connection) {
        String convertedVars = PowerShellVarsConverter.javaToPowerShell(connection, this.powerShellVars, this.uploadArtifactData);
        StringBuilder b = new StringBuilder();
        b.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
        if (this.container instanceof PowerShellContainer) {
            b.append(ScriptUtils.loadScriptDir((String)((PowerShellContainer)this.container).getRuntimePath()));
        }
        b.append("# PowerShellVars\n");
        b.append(convertedVars);
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
        return b.toString().replaceAll("\n", "\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executePowerShellScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        logger.info("Executing PowerShell script {} on {}", (Object)script, (Object)conn);
        DefaultProcessOutputHandler handler = new DefaultProcessOutputHandler(ctx);
        try {
            CmdLine cmdLine = this.container instanceof PowerShellContainer ? ((PowerShellContainer)this.container).getScriptCommandLine(script) : this.getDefaultScriptCommandLine(script);
            int n = conn.execute((OverthereProcessOutputHandler)handler, cmdLine);
            return n;
        }
        finally {
            handler.close();
        }
    }

    private CmdLine getDefaultScriptCommandLine(OverthereFile script) {
        return CmdLine.build((String[])new String[]{"powershell", "-NonInteractive", "-inputformat", "none", "-ExecutionPolicy", "unrestricted", "-File", script.getPath()});
    }

    public String getDescription() {
        return this.description;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }
}

