/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.bcrypt;

import java.security.SecureRandom;
import org.springframework.security.crypto.bcrypt.BCrypt;
import org.springframework.security.crypto.password.PasswordEncoder;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    private final int strength;
    private final SecureRandom random;

    public BCryptPasswordEncoder() {
        this(-1);
    }

    public BCryptPasswordEncoder(int strength) {
        this(strength, null);
    }

    public BCryptPasswordEncoder(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    public String encode(CharSequence rawPassword) {
        String salt = this.strength > 0 ? (this.random != null ? BCrypt.gensalt(this.strength, this.random) : BCrypt.gensalt(this.strength)) : BCrypt.gensalt();
        return BCrypt.hashpw(((Object)rawPassword).toString(), salt);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return BCrypt.checkpw(((Object)rawPassword).toString(), encodedPassword);
    }
}

