/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Set;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;

public class SetBasedFieldSelector
implements FieldSelector {
    private Set fieldsToLoad;
    private Set lazyFieldsToLoad;

    public SetBasedFieldSelector(Set fieldsToLoad, Set lazyFieldsToLoad) {
        this.fieldsToLoad = fieldsToLoad;
        this.lazyFieldsToLoad = lazyFieldsToLoad;
    }

    public FieldSelectorResult accept(String fieldName) {
        FieldSelectorResult result = FieldSelectorResult.NO_LOAD;
        if (this.fieldsToLoad.contains(fieldName)) {
            result = FieldSelectorResult.LOAD;
        }
        if (this.lazyFieldsToLoad.contains(fieldName)) {
            result = FieldSelectorResult.LAZY_LOAD;
        }
        return result;
    }
}

