/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hpbf.HPBFDocument;
import org.apache.poi.hpbf.model.qcbits.QCBit;
import org.apache.poi.hpbf.model.qcbits.QCPLCBit;
import org.apache.poi.hpbf.model.qcbits.QCTextBit;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class PublisherTextExtractor
extends POIOLE2TextExtractor {
    private HPBFDocument doc;
    private boolean hyperlinksByDefault = false;

    public PublisherTextExtractor(HPBFDocument doc) {
        super((POIDocument)doc);
        this.doc = doc;
    }

    public PublisherTextExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HPBFDocument(dir, fs));
    }

    public PublisherTextExtractor(POIFSFileSystem fs) throws IOException {
        this(new HPBFDocument(fs));
    }

    public PublisherTextExtractor(InputStream is) throws IOException {
        this(new POIFSFileSystem(is));
    }

    public void setHyperlinksByDefault(boolean hyperlinksByDefault) {
        this.hyperlinksByDefault = hyperlinksByDefault;
    }

    public String getText() {
        int i;
        StringBuffer text = new StringBuffer();
        QCBit[] bits = this.doc.getQuillContents().getBits();
        for (i = 0; i < bits.length; ++i) {
            if (bits[i] == null || !(bits[i] instanceof QCTextBit)) continue;
            QCTextBit t = (QCTextBit)bits[i];
            text.append(t.getText().replace('\r', '\n'));
        }
        if (this.hyperlinksByDefault) {
            for (i = 0; i < bits.length; ++i) {
                if (bits[i] == null || !(bits[i] instanceof QCPLCBit.Type12)) continue;
                QCPLCBit.Type12 hyperlinks = (QCPLCBit.Type12)bits[i];
                for (int j = 0; j < hyperlinks.getNumberOfHyperlinks(); ++j) {
                    text.append("<");
                    text.append(hyperlinks.getHyperlink(j));
                    text.append(">\n");
                }
            }
        }
        return text.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("  PublisherTextExtractor <file.pub>");
        }
        for (int i = 0; i < args.length; ++i) {
            PublisherTextExtractor te = new PublisherTextExtractor(new FileInputStream(args[i]));
            System.out.println(te.getText());
        }
    }
}

