/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.xml.Converters;
import com.xebialabs.deployit.engine.xml.XStreamProvider;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import java.util.Collection;
import java.util.List;

@XStreamProvider(tagName="deployment", readable=Deployment.class)
public class DeploymentConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Deployment depl = (Deployment)source;
        writer.addAttribute("type", depl.getDeploymentType().name());
        writer.startNode("application");
        Converters.writeConfigurationItem(depl.getDeployedApplication(), writer, context);
        writer.endNode();
        writer.startNode("deployeds");
        for (ConfigurationItem configurationItem : depl.getDeployeds()) {
            Converters.writeConfigurationItem(configurationItem, writer, context);
            this.writeEmbeddeds(configurationItem, writer, context);
        }
        writer.endNode();
        this.writeIds("deployables", depl.getDeployables(), writer, context);
        this.writeIds("containers", depl.getContainers(), writer, context);
    }

    private void writeEmbeddeds(ConfigurationItem configurationItem, HierarchicalStreamWriter writer, MarshallingContext context) {
        FluentIterable propertyDescriptors = FluentIterable.from((Iterable)configurationItem.getType().getDescriptor().getPropertyDescriptors()).filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return DeploymentConverter.this.isEmbeddedDeployedProperty(input);
            }
        });
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Collection cis = (Collection)propertyDescriptor.get(configurationItem);
            if (cis == null || cis.isEmpty() || !(cis.iterator().next() instanceof ConfigurationItem)) continue;
            for (ConfigurationItem ci : cis) {
                Converters.writeConfigurationItem(ci, writer, context);
                this.writeEmbeddeds(ci, writer, context);
            }
        }
    }

    private boolean isEmbeddedDeployedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }

    private void writeIds(String nodeName, List<ConfigurationItemId> ids, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode(nodeName);
        for (ConfigurationItemId configurationItemId : ids) {
            this.writerConfigurationItemId(configurationItemId, writer, context);
        }
        writer.endNode();
    }

    private void writerConfigurationItemId(ConfigurationItemId configurationItemId, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode("ci");
        context.convertAnother((Object)configurationItemId);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Deployment depl = new Deployment();
        depl.setDeploymentType(Deployment.DeploymentType.valueOf((String)reader.getAttribute("type")));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("application".equals(reader.getNodeName())) {
                reader.moveDown();
                ConfigurationItem ci = (ConfigurationItem)context.convertAnother((Object)depl, ConfigurationItem.class);
                depl.setDeployedApplication(ci);
                reader.moveUp();
            } else if ("deployeds".equals(reader.getNodeName())) {
                depl.setDeployeds(Converters.readList(depl, ConfigurationItem.class, reader, context));
            } else if ("deployables".equals(reader.getNodeName())) {
                depl.setDeployables(Converters.readList(depl, ConfigurationItemId.class, reader, context));
            } else if ("containers".equals(reader.getNodeName())) {
                depl.setContainers(Converters.readList(depl, ConfigurationItemId.class, reader, context));
            }
            reader.moveUp();
        }
        return depl;
    }

    public boolean canConvert(Class type) {
        return Deployment.class.isAssignableFrom(type);
    }
}

