/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DeployedArtifactPlaceholdersResolver {
    public static final String PLACEHOLDERS_FIELD = "placeholders";

    public void resolvePlaceholders(Deployed<?, ?> deployed, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        if (!deployed.hasProperty(PLACEHOLDERS_FIELD)) {
            return;
        }
        Set placeholders = (Set)((Deployable)deployed.getDeployable()).getProperty(PLACEHOLDERS_FIELD);
        Map existingDeployedPlaceholders = Maps.newHashMap();
        if (existingDeployed != null && existingDeployed.hasProperty(PLACEHOLDERS_FIELD)) {
            existingDeployedPlaceholders = (Map)existingDeployed.getProperty(PLACEHOLDERS_FIELD);
        }
        deployed.setProperty(PLACEHOLDERS_FIELD, this.resolvePlaceholders(existingDeployedPlaceholders, placeholders, dictionary));
    }

    private Map<String, String> resolvePlaceholders(Map<String, String> existingPlaceholders, Set<String> deployablePlaceholders, ConsolidatedDictionary dictionary) {
        MapStringStringView newDeployedPlaceholders = new MapStringStringView();
        MapStringStringView existingDeployedPlaceholders = MapStringStringView.of(existingPlaceholders);
        for (String deployablePlaceholder : deployablePlaceholders) {
            StringValue placeholderValue = dictionary.resolveScannedPlaceholder(deployablePlaceholder);
            if (placeholderValue == null) {
                placeholderValue = existingDeployedPlaceholders.containsKey(deployablePlaceholder) ? existingDeployedPlaceholders.getWrappedValue(deployablePlaceholder) : new StringValue("");
            }
            newDeployedPlaceholders.put(deployablePlaceholder, placeholderValue);
        }
        return newDeployedPlaceholders;
    }
}

