/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedArtifactPlaceholdersResolver;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.deployment.ManualTagMatcher;
import com.xebialabs.deployit.service.deployment.TagMatcher;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private TypeCalculator calculator;
    private TagMatcher tagMatcher;
    private DeployedArtifactPlaceholdersResolver placeholdersResolver;
    private DeployedPropertySetter deployedPropertySetter;
    private final ManualTagMatcher manualTagMatcher;
    private static final Logger logger = LoggerFactory.getLogger(DeployedGenerator.class);

    @Autowired
    public DeployedGenerator(TypeCalculator calculator, DeployedArtifactPlaceholdersResolver placeholdersResolver, DeployedPropertySetter deployedPropertySetter) {
        this.calculator = calculator;
        this.placeholdersResolver = placeholdersResolver;
        this.deployedPropertySetter = deployedPropertySetter;
        this.tagMatcher = new TagMatcher();
        this.manualTagMatcher = new ManualTagMatcher();
    }

    public Deployed<?, ?> createMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, this.manualTagMatcher);
    }

    public Deployed<?, ?> autoGenerateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, this.tagMatcher);
    }

    public Deployed<?, ?> generateDeployed(Deployable deployable, Container container, Type deployedType, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> deployed = this.basicDeployed(deployable, container, deployedType);
        this.deployedPropertySetter.setProperties((EmbeddedDeployedContainer)deployed, null, dictionary);
        this.placeholdersResolver.resolvePlaceholders(deployed, null, dictionary);
        return deployed;
    }

    private Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary, TagMatcher tagMatcher) {
        Type deployedType = this.calculator.findMostSpecificDeployedTypeForDeployableAndContainerTypes(deployable.getType(), container.getType());
        if (deployedType != null && tagMatcher.areMatching(deployable, container)) {
            return this.generateDeployed(deployable, container, deployedType, dictionary);
        }
        return null;
    }

    private Deployed<Deployable, Container> basicDeployed(Deployable deployable, Container container, Type deployedType) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed deployed = (Deployed)deployedDesc.newInstance();
        deployed.setDeployable((ConfigurationItem)deployable);
        deployed.setContainer((ConfigurationItem)container);
        IdGenerator.generateId((Deployed)deployed);
        return deployed;
    }

    public Deployed<?, ?> generateUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> upgradedDeployed = this.createUpgradedDeployed(newDeployable, existingDeployed);
        this.deployedPropertySetter.setProperties((EmbeddedDeployedContainer)upgradedDeployed, (EmbeddedDeployedContainer)existingDeployed, dictionary);
        this.placeholdersResolver.resolvePlaceholders(upgradedDeployed, existingDeployed, dictionary);
        return upgradedDeployed;
    }

    private Deployed<Deployable, Container> createUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed) {
        Type newDeployableType;
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)existingDeployed.getType());
        Type deployableType = deployedDesc.getDeployableType();
        Checks.checkArgument(deployableType.equals((Object)(newDeployableType = newDeployable.getType())) || DescriptorRegistry.getSubtypes((Type)deployableType).contains(newDeployableType), "The new Deployable type %s should be assignable to %s", newDeployableType, deployableType);
        Deployed upgradedDeployed = (Deployed)deployedDesc.newInstance();
        upgradedDeployed.setDeployable((ConfigurationItem)newDeployable);
        upgradedDeployed.setContainer(existingDeployed.getContainer());
        upgradedDeployed.setId(existingDeployed.getId());
        return upgradedDeployed;
    }
}

