/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private DeployedGenerator deployedGenerator;
    private TypeCalculator typeCalculator;
    private static final Logger logger = LoggerFactory.getLogger(DeployedService.class);

    @Autowired
    public DeployedService(DeployedGenerator deployedGenerator, TypeCalculator typeCalculator) {
        this.deployedGenerator = deployedGenerator;
        this.typeCalculator = typeCalculator;
    }

    public ListMultimap<Boolean, ConfigurationItem> generateAllDeployeds(Version pkg, Environment env) {
        Set containers = env.getMembers();
        ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(env.getDictionaries());
        List<Deployed<?, ?>> validDeployeds = this.generateDeployedsOfType(pkg.getDeployables(), containers, null, dictionary);
        if (validDeployeds.isEmpty()) {
            throw new Checks.IncorrectArgumentException("Could not generate any deployeds for " + pkg.getId() + " and " + env.getId(), new Object[0]);
        }
        return this.createValidDeployedMap(validDeployeds, Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateSelectedDeployeds(List<ConfigurationItem> deployableCis, Environment env) {
        Set containers = env.getMembers();
        ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(env.getDictionaries());
        List deployables = Lists.transform(deployableCis, (Function)new Function<ConfigurationItem, Deployable>(){

            public Deployable apply(ConfigurationItem from) {
                Checks.checkArgument(from instanceof Deployable, "The entity %s is not a deployable", from.getId());
                return (Deployable)from;
            }
        });
        return this.createValidDeployedMap(this.generateDeployedsOfType(deployables, containers, null, dictionary), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> createSelectedDeployed(Deployable deployable, Container container, Type deployedType, Environment env) {
        logger.debug("Creating deployed for [{}] and [{}]", (Object)deployable, (Object)container);
        ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(env.getDictionaries());
        return this.createValidDeployedMap(this.generateDeployedsOfType(Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), deployedType, dictionary, true), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateUpgradedDeployeds(Version newPackage, DeployedApplication deployment) {
        Environment environment = deployment.getEnvironment();
        ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(environment.getDictionaries());
        ArrayList upgradeDeployeds = Lists.newArrayList();
        ArrayList oldDeployeds = Lists.newArrayList();
        for (final Deployed deployed : deployment.getDeployeds()) {
            Collection filtered = Collections2.filter((Collection)newPackage.getDeployables(), (Predicate)new Predicate<Deployable>(){

                public boolean apply(Deployable input) {
                    return DeployedService.this.isSimilar(input, (Deployable)deployed.getDeployable());
                }
            });
            if (filtered.size() == 0) {
                oldDeployeds.add(this.deployedGenerator.generateUpgradedDeployed((Deployable)deployed.getDeployable(), deployed, dictionary));
                continue;
            }
            if (filtered.size() == 1) {
                upgradeDeployeds.add(this.deployedGenerator.generateUpgradedDeployed((Deployable)filtered.iterator().next(), deployed, dictionary));
                continue;
            }
            throw new IllegalArgumentException(String.format("More than 1 applicable deployable found in new package for %s, will not fly.", deployed));
        }
        return this.createValidDeployedMap(upgradeDeployeds, oldDeployeds);
    }

    private ListMultimap<Boolean, ConfigurationItem> createValidDeployedMap(List<Deployed<?, ?>> validDeployeds, List<Deployed<?, ?>> invalidDeployeds) {
        ArrayListMultimap deployedsMap = ArrayListMultimap.create();
        deployedsMap.putAll((Object)Boolean.TRUE, validDeployeds);
        deployedsMap.putAll((Object)Boolean.FALSE, invalidDeployeds);
        return deployedsMap;
    }

    private boolean isSimilar(Deployable newDeployable, Deployable deployable) {
        return newDeployable.getType().equals((Object)deployable.getType()) && newDeployable.getName().equals(deployable.getName());
    }

    private List<Deployed<?, ?>> generateDeployedsOfType(Collection<Deployable> deployables, Collection<Container> containers, Type deployedType, ConsolidatedDictionary dictionary) {
        return this.generateDeployedsOfType(deployables, containers, deployedType, dictionary, false);
    }

    private List<Deployed<?, ?>> generateDeployedsOfType(Collection<Deployable> deployables, Collection<Container> containers, Type deployedType, ConsolidatedDictionary dictionary, boolean manualAction) {
        ArrayList deployeds = Lists.newArrayList();
        for (Deployable deployable : deployables) {
            for (Container container : containers) {
                Deployed<?, ?> deployed;
                if (deployedType != null) {
                    if (!this.typeCalculator.findDeployedTypesForDeployableAndContainerTypes(deployable.getType(), container.getType()).contains(deployedType)) continue;
                    deployeds.add(this.deployedGenerator.generateDeployed(deployable, container, deployedType, dictionary));
                    continue;
                }
                if (manualAction) {
                    logger.debug("Creating manual deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.createMostSpecificDeployed(deployable, container, dictionary);
                } else {
                    logger.debug("Creating automatic deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.autoGenerateMostSpecificDeployed(deployable, container, dictionary);
                }
                if (deployed == null) continue;
                deployeds.add(deployed);
            }
        }
        return deployeds;
    }
}

